/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHypervisorRequest extends BackupGatewayRequest implements
        ToCopyableBuilder<UpdateHypervisorRequest.Builder, UpdateHypervisorRequest> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(UpdateHypervisorRequest::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HypervisorArn").getter(getter(UpdateHypervisorRequest::hypervisorArn))
            .setter(setter(Builder::hypervisorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(UpdateHypervisorRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UpdateHypervisorRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD,
            HYPERVISOR_ARN_FIELD, PASSWORD_FIELD, USERNAME_FIELD));

    private final String host;

    private final String hypervisorArn;

    private final String password;

    private final String username;

    private UpdateHypervisorRequest(BuilderImpl builder) {
        super(builder);
        this.host = builder.host;
        this.hypervisorArn = builder.hypervisorArn;
        this.password = builder.password;
        this.username = builder.username;
    }

    /**
     * <p>
     * The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
     * </p>
     * 
     * @return The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name
     *         (FQDN).
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hypervisor to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hypervisor to update.
     */
    public final String hypervisorArn() {
        return hypervisorArn;
    }

    /**
     * <p>
     * The updated password for the hypervisor.
     * </p>
     * 
     * @return The updated password for the hypervisor.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The updated username for the hypervisor.
     * </p>
     * 
     * @return The updated username for the hypervisor.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHypervisorRequest)) {
            return false;
        }
        UpdateHypervisorRequest other = (UpdateHypervisorRequest) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(hypervisorArn(), other.hypervisorArn())
                && Objects.equals(password(), other.password()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHypervisorRequest").add("Host", host()).add("HypervisorArn", hypervisorArn())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "HypervisorArn":
            return Optional.ofNullable(clazz.cast(hypervisorArn()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHypervisorRequest, T> g) {
        return obj -> g.apply((UpdateHypervisorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHypervisorRequest> {
        /**
         * <p>
         * The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
         * </p>
         * 
         * @param host
         *        The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name
         *        (FQDN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hypervisor to update.
         * </p>
         * 
         * @param hypervisorArn
         *        The Amazon Resource Name (ARN) of the hypervisor to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisorArn(String hypervisorArn);

        /**
         * <p>
         * The updated password for the hypervisor.
         * </p>
         * 
         * @param password
         *        The updated password for the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The updated username for the hypervisor.
         * </p>
         * 
         * @param username
         *        The updated username for the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupGatewayRequest.BuilderImpl implements Builder {
        private String host;

        private String hypervisorArn;

        private String password;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHypervisorRequest model) {
            super(model);
            host(model.host);
            hypervisorArn(model.hypervisorArn);
            password(model.password);
            username(model.username);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        @Transient
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getHypervisorArn() {
            return hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        @Transient
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        @Transient
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHypervisorRequest build() {
            return new UpdateHypervisorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
