/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListTieringConfigurationsRequest;
import software.amazon.awssdk.services.backup.model.ListTieringConfigurationsResponse;
import software.amazon.awssdk.services.backup.model.TieringConfigurationsListMember;

public class ListTieringConfigurationsPublisher
implements SdkPublisher<ListTieringConfigurationsResponse> {
    private final BackupAsyncClient client;
    private final ListTieringConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTieringConfigurationsPublisher(BackupAsyncClient client, ListTieringConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTieringConfigurationsPublisher(BackupAsyncClient client, ListTieringConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTieringConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTieringConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TieringConfigurationsListMember> tieringConfigurations() {
        Function<ListTieringConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tieringConfigurations() != null) {
                return response.tieringConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTieringConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTieringConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListTieringConfigurationsResponse> {
        private ListTieringConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTieringConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTieringConfigurationsResponse> nextPage(ListTieringConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTieringConfigurationsPublisher.this.client.listTieringConfigurations(ListTieringConfigurationsPublisher.this.firstRequest);
            }
            return ListTieringConfigurationsPublisher.this.client.listTieringConfigurations((ListTieringConfigurationsRequest)((Object)ListTieringConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

