/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.VaultType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupVaultsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListBackupVaultsRequest> {
    private static final SdkField<String> BY_VAULT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByVaultType").getter(ListBackupVaultsRequest.getter(ListBackupVaultsRequest::byVaultTypeAsString)).setter(ListBackupVaultsRequest.setter(Builder::byVaultType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vaultType").build()}).build();
    private static final SdkField<Boolean> BY_SHARED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ByShared").getter(ListBackupVaultsRequest.getter(ListBackupVaultsRequest::byShared)).setter(ListBackupVaultsRequest.setter(Builder::byShared)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("shared").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBackupVaultsRequest.getter(ListBackupVaultsRequest::nextToken)).setter(ListBackupVaultsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListBackupVaultsRequest.getter(ListBackupVaultsRequest::maxResults)).setter(ListBackupVaultsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_VAULT_TYPE_FIELD, BY_SHARED_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBackupVaultsRequest.memberNameToFieldInitializer();
    private final String byVaultType;
    private final Boolean byShared;
    private final String nextToken;
    private final Integer maxResults;

    private ListBackupVaultsRequest(BuilderImpl builder) {
        super(builder);
        this.byVaultType = builder.byVaultType;
        this.byShared = builder.byShared;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final VaultType byVaultType() {
        return VaultType.fromValue(this.byVaultType);
    }

    public final String byVaultTypeAsString() {
        return this.byVaultType;
    }

    public final Boolean byShared() {
        return this.byShared;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.byVaultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byShared());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupVaultsRequest)) {
            return false;
        }
        ListBackupVaultsRequest other = (ListBackupVaultsRequest)((Object)obj);
        return Objects.equals(this.byVaultTypeAsString(), other.byVaultTypeAsString()) && Objects.equals(this.byShared(), other.byShared()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListBackupVaultsRequest").add("ByVaultType", (Object)this.byVaultTypeAsString()).add("ByShared", (Object)this.byShared()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByVaultType": {
                return Optional.ofNullable(clazz.cast(this.byVaultTypeAsString()));
            }
            case "ByShared": {
                return Optional.ofNullable(clazz.cast(this.byShared()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vaultType", BY_VAULT_TYPE_FIELD);
        map.put("shared", BY_SHARED_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBackupVaultsRequest, T> g) {
        return obj -> g.apply((ListBackupVaultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String byVaultType;
        private Boolean byShared;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupVaultsRequest model) {
            super(model);
            this.byVaultType(model.byVaultType);
            this.byShared(model.byShared);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getByVaultType() {
            return this.byVaultType;
        }

        public final void setByVaultType(String byVaultType) {
            this.byVaultType = byVaultType;
        }

        @Override
        public final Builder byVaultType(String byVaultType) {
            this.byVaultType = byVaultType;
            return this;
        }

        @Override
        public final Builder byVaultType(VaultType byVaultType) {
            this.byVaultType(byVaultType == null ? null : byVaultType.toString());
            return this;
        }

        public final Boolean getByShared() {
            return this.byShared;
        }

        public final void setByShared(Boolean byShared) {
            this.byShared = byShared;
        }

        @Override
        public final Builder byShared(Boolean byShared) {
            this.byShared = byShared;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupVaultsRequest build() {
            return new ListBackupVaultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupVaultsRequest> {
        public Builder byVaultType(String var1);

        public Builder byVaultType(VaultType var1);

        public Builder byShared(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

