/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.IndexStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexedRecoveryPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexedRecoveryPoint> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::recoveryPointArn)).setter(IndexedRecoveryPoint.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResourceArn").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::sourceResourceArn)).setter(IndexedRecoveryPoint.setter(Builder::sourceResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::iamRoleArn)).setter(IndexedRecoveryPoint.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<Instant> BACKUP_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BackupCreationDate").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::backupCreationDate)).setter(IndexedRecoveryPoint.setter(Builder::backupCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupCreationDate").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::resourceType)).setter(IndexedRecoveryPoint.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> INDEX_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IndexCreationDate").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::indexCreationDate)).setter(IndexedRecoveryPoint.setter(Builder::indexCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCreationDate").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::indexStatusAsString)).setter(IndexedRecoveryPoint.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatusMessage").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::indexStatusMessage)).setter(IndexedRecoveryPoint.setter(Builder::indexStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(IndexedRecoveryPoint.getter(IndexedRecoveryPoint::backupVaultArn)).setter(IndexedRecoveryPoint.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD, SOURCE_RESOURCE_ARN_FIELD, IAM_ROLE_ARN_FIELD, BACKUP_CREATION_DATE_FIELD, RESOURCE_TYPE_FIELD, INDEX_CREATION_DATE_FIELD, INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD, BACKUP_VAULT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IndexedRecoveryPoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recoveryPointArn;
    private final String sourceResourceArn;
    private final String iamRoleArn;
    private final Instant backupCreationDate;
    private final String resourceType;
    private final Instant indexCreationDate;
    private final String indexStatus;
    private final String indexStatusMessage;
    private final String backupVaultArn;

    private IndexedRecoveryPoint(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.backupCreationDate = builder.backupCreationDate;
        this.resourceType = builder.resourceType;
        this.indexCreationDate = builder.indexCreationDate;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
        this.backupVaultArn = builder.backupVaultArn;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String sourceResourceArn() {
        return this.sourceResourceArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final Instant backupCreationDate() {
        return this.backupCreationDate;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Instant indexCreationDate() {
        return this.indexCreationDate;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final String indexStatusMessage() {
        return this.indexStatusMessage;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexedRecoveryPoint)) {
            return false;
        }
        IndexedRecoveryPoint other = (IndexedRecoveryPoint)obj;
        return Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.sourceResourceArn(), other.sourceResourceArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.backupCreationDate(), other.backupCreationDate()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.indexCreationDate(), other.indexCreationDate()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.indexStatusMessage(), other.indexStatusMessage()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn());
    }

    public final String toString() {
        return ToString.builder((String)"IndexedRecoveryPoint").add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("SourceResourceArn", (Object)this.sourceResourceArn()).add("IamRoleArn", (Object)this.iamRoleArn()).add("BackupCreationDate", (Object)this.backupCreationDate()).add("ResourceType", (Object)this.resourceType()).add("IndexCreationDate", (Object)this.indexCreationDate()).add("IndexStatus", (Object)this.indexStatusAsString()).add("IndexStatusMessage", (Object)this.indexStatusMessage()).add("BackupVaultArn", (Object)this.backupVaultArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "SourceResourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "BackupCreationDate": {
                return Optional.ofNullable(clazz.cast(this.backupCreationDate()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "IndexCreationDate": {
                return Optional.ofNullable(clazz.cast(this.indexCreationDate()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "IndexStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.indexStatusMessage()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("BackupCreationDate", BACKUP_CREATION_DATE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("IndexCreationDate", INDEX_CREATION_DATE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexedRecoveryPoint, T> g) {
        return obj -> g.apply((IndexedRecoveryPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recoveryPointArn;
        private String sourceResourceArn;
        private String iamRoleArn;
        private Instant backupCreationDate;
        private String resourceType;
        private Instant indexCreationDate;
        private String indexStatus;
        private String indexStatusMessage;
        private String backupVaultArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexedRecoveryPoint model) {
            this.recoveryPointArn(model.recoveryPointArn);
            this.sourceResourceArn(model.sourceResourceArn);
            this.iamRoleArn(model.iamRoleArn);
            this.backupCreationDate(model.backupCreationDate);
            this.resourceType(model.resourceType);
            this.indexCreationDate(model.indexCreationDate);
            this.indexStatus(model.indexStatus);
            this.indexStatusMessage(model.indexStatusMessage);
            this.backupVaultArn(model.backupVaultArn);
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return this.sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Instant getBackupCreationDate() {
            return this.backupCreationDate;
        }

        public final void setBackupCreationDate(Instant backupCreationDate) {
            this.backupCreationDate = backupCreationDate;
        }

        @Override
        public final Builder backupCreationDate(Instant backupCreationDate) {
            this.backupCreationDate = backupCreationDate;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getIndexCreationDate() {
            return this.indexCreationDate;
        }

        public final void setIndexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
        }

        @Override
        public final Builder indexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return this.indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public IndexedRecoveryPoint build() {
            return new IndexedRecoveryPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexedRecoveryPoint> {
        public Builder recoveryPointArn(String var1);

        public Builder sourceResourceArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder backupCreationDate(Instant var1);

        public Builder resourceType(String var1);

        public Builder indexCreationDate(Instant var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder indexStatusMessage(String var1);

        public Builder backupVaultArn(String var1);
    }
}

