/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse;

public class ListCopyJobSummariesIterable
implements SdkIterable<ListCopyJobSummariesResponse> {
    private final BackupClient client;
    private final ListCopyJobSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCopyJobSummariesIterable(BackupClient client, ListCopyJobSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCopyJobSummariesResponseFetcher();
    }

    public Iterator<ListCopyJobSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCopyJobSummariesResponseFetcher
    implements SyncPageFetcher<ListCopyJobSummariesResponse> {
        private ListCopyJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListCopyJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCopyJobSummariesResponse nextPage(ListCopyJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListCopyJobSummariesIterable.this.client.listCopyJobSummaries(ListCopyJobSummariesIterable.this.firstRequest);
            }
            return ListCopyJobSummariesIterable.this.client.listCopyJobSummaries((ListCopyJobSummariesRequest)((Object)ListCopyJobSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

