/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model._stringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportSetting> {
    private static final SdkField<String> REPORT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportTemplate").getter(ReportSetting.getter(ReportSetting::reportTemplate)).setter(ReportSetting.setter(Builder::reportTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTemplate").build()}).build();
    private static final SdkField<List<String>> FRAMEWORK_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FrameworkArns").getter(ReportSetting.getter(ReportSetting::frameworkArns)).setter(ReportSetting.setter(Builder::frameworkArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_FRAMEWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfFrameworks").getter(ReportSetting.getter(ReportSetting::numberOfFrameworks)).setter(ReportSetting.setter(Builder::numberOfFrameworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFrameworks").build()}).build();
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(ReportSetting.getter(ReportSetting::accounts)).setter(ReportSetting.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ORGANIZATION_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationUnits").getter(ReportSetting.getter(ReportSetting::organizationUnits)).setter(ReportSetting.setter(Builder::organizationUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(ReportSetting.getter(ReportSetting::regions)).setter(ReportSetting.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_TEMPLATE_FIELD, FRAMEWORK_ARNS_FIELD, NUMBER_OF_FRAMEWORKS_FIELD, ACCOUNTS_FIELD, ORGANIZATION_UNITS_FIELD, REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reportTemplate;
    private final List<String> frameworkArns;
    private final Integer numberOfFrameworks;
    private final List<String> accounts;
    private final List<String> organizationUnits;
    private final List<String> regions;

    private ReportSetting(BuilderImpl builder) {
        this.reportTemplate = builder.reportTemplate;
        this.frameworkArns = builder.frameworkArns;
        this.numberOfFrameworks = builder.numberOfFrameworks;
        this.accounts = builder.accounts;
        this.organizationUnits = builder.organizationUnits;
        this.regions = builder.regions;
    }

    public final String reportTemplate() {
        return this.reportTemplate;
    }

    public final boolean hasFrameworkArns() {
        return this.frameworkArns != null && !(this.frameworkArns instanceof SdkAutoConstructList);
    }

    public final List<String> frameworkArns() {
        return this.frameworkArns;
    }

    public final Integer numberOfFrameworks() {
        return this.numberOfFrameworks;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<String> accounts() {
        return this.accounts;
    }

    public final boolean hasOrganizationUnits() {
        return this.organizationUnits != null && !(this.organizationUnits instanceof SdkAutoConstructList);
    }

    public final List<String> organizationUnits() {
        return this.organizationUnits;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameworkArns() ? this.frameworkArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFrameworks());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationUnits() ? this.organizationUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportSetting)) {
            return false;
        }
        ReportSetting other = (ReportSetting)obj;
        return Objects.equals(this.reportTemplate(), other.reportTemplate()) && this.hasFrameworkArns() == other.hasFrameworkArns() && Objects.equals(this.frameworkArns(), other.frameworkArns()) && Objects.equals(this.numberOfFrameworks(), other.numberOfFrameworks()) && this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && this.hasOrganizationUnits() == other.hasOrganizationUnits() && Objects.equals(this.organizationUnits(), other.organizationUnits()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"ReportSetting").add("ReportTemplate", (Object)this.reportTemplate()).add("FrameworkArns", this.hasFrameworkArns() ? this.frameworkArns() : null).add("NumberOfFrameworks", (Object)this.numberOfFrameworks()).add("Accounts", this.hasAccounts() ? this.accounts() : null).add("OrganizationUnits", this.hasOrganizationUnits() ? this.organizationUnits() : null).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportTemplate": {
                return Optional.ofNullable(clazz.cast(this.reportTemplate()));
            }
            case "FrameworkArns": {
                return Optional.ofNullable(clazz.cast(this.frameworkArns()));
            }
            case "NumberOfFrameworks": {
                return Optional.ofNullable(clazz.cast(this.numberOfFrameworks()));
            }
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "OrganizationUnits": {
                return Optional.ofNullable(clazz.cast(this.organizationUnits()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportTemplate", REPORT_TEMPLATE_FIELD);
        map.put("FrameworkArns", FRAMEWORK_ARNS_FIELD);
        map.put("NumberOfFrameworks", NUMBER_OF_FRAMEWORKS_FIELD);
        map.put("Accounts", ACCOUNTS_FIELD);
        map.put("OrganizationUnits", ORGANIZATION_UNITS_FIELD);
        map.put("Regions", REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportSetting, T> g) {
        return obj -> g.apply((ReportSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportTemplate;
        private List<String> frameworkArns = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfFrameworks;
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();
        private List<String> organizationUnits = DefaultSdkAutoConstructList.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportSetting model) {
            this.reportTemplate(model.reportTemplate);
            this.frameworkArns(model.frameworkArns);
            this.numberOfFrameworks(model.numberOfFrameworks);
            this.accounts(model.accounts);
            this.organizationUnits(model.organizationUnits);
            this.regions(model.regions);
        }

        public final String getReportTemplate() {
            return this.reportTemplate;
        }

        public final void setReportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
        }

        @Override
        public final Builder reportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
            return this;
        }

        public final Collection<String> getFrameworkArns() {
            if (this.frameworkArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.frameworkArns;
        }

        public final void setFrameworkArns(Collection<String> frameworkArns) {
            this.frameworkArns = _stringListCopier.copy(frameworkArns);
        }

        @Override
        public final Builder frameworkArns(Collection<String> frameworkArns) {
            this.frameworkArns = _stringListCopier.copy(frameworkArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkArns(String ... frameworkArns) {
            this.frameworkArns(Arrays.asList(frameworkArns));
            return this;
        }

        public final Integer getNumberOfFrameworks() {
            return this.numberOfFrameworks;
        }

        public final void setNumberOfFrameworks(Integer numberOfFrameworks) {
            this.numberOfFrameworks = numberOfFrameworks;
        }

        @Override
        public final Builder numberOfFrameworks(Integer numberOfFrameworks) {
            this.numberOfFrameworks = numberOfFrameworks;
            return this;
        }

        public final Collection<String> getAccounts() {
            if (this.accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = _stringListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = _stringListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final Collection<String> getOrganizationUnits() {
            if (this.organizationUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationUnits;
        }

        public final void setOrganizationUnits(Collection<String> organizationUnits) {
            this.organizationUnits = _stringListCopier.copy(organizationUnits);
        }

        @Override
        public final Builder organizationUnits(Collection<String> organizationUnits) {
            this.organizationUnits = _stringListCopier.copy(organizationUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationUnits(String ... organizationUnits) {
            this.organizationUnits(Arrays.asList(organizationUnits));
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _stringListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = _stringListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public ReportSetting build() {
            return new ReportSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportSetting> {
        public Builder reportTemplate(String var1);

        public Builder frameworkArns(Collection<String> var1);

        public Builder frameworkArns(String ... var1);

        public Builder numberOfFrameworks(Integer var1);

        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);

        public Builder organizationUnits(Collection<String> var1);

        public Builder organizationUnits(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);
    }
}

