/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.X12FunctionalAcknowledgment;
import software.amazon.awssdk.services.b2bi.model.X12TechnicalAcknowledgment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12AcknowledgmentOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12AcknowledgmentOptions> {
    private static final SdkField<String> FUNCTIONAL_ACKNOWLEDGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionalAcknowledgment").getter(X12AcknowledgmentOptions.getter(X12AcknowledgmentOptions::functionalAcknowledgmentAsString)).setter(X12AcknowledgmentOptions.setter(Builder::functionalAcknowledgment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionalAcknowledgment").build()}).build();
    private static final SdkField<String> TECHNICAL_ACKNOWLEDGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("technicalAcknowledgment").getter(X12AcknowledgmentOptions.getter(X12AcknowledgmentOptions::technicalAcknowledgmentAsString)).setter(X12AcknowledgmentOptions.setter(Builder::technicalAcknowledgment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("technicalAcknowledgment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTIONAL_ACKNOWLEDGMENT_FIELD, TECHNICAL_ACKNOWLEDGMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = X12AcknowledgmentOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String functionalAcknowledgment;
    private final String technicalAcknowledgment;

    private X12AcknowledgmentOptions(BuilderImpl builder) {
        this.functionalAcknowledgment = builder.functionalAcknowledgment;
        this.technicalAcknowledgment = builder.technicalAcknowledgment;
    }

    public final X12FunctionalAcknowledgment functionalAcknowledgment() {
        return X12FunctionalAcknowledgment.fromValue(this.functionalAcknowledgment);
    }

    public final String functionalAcknowledgmentAsString() {
        return this.functionalAcknowledgment;
    }

    public final X12TechnicalAcknowledgment technicalAcknowledgment() {
        return X12TechnicalAcknowledgment.fromValue(this.technicalAcknowledgment);
    }

    public final String technicalAcknowledgmentAsString() {
        return this.technicalAcknowledgment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionalAcknowledgmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.technicalAcknowledgmentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12AcknowledgmentOptions)) {
            return false;
        }
        X12AcknowledgmentOptions other = (X12AcknowledgmentOptions)obj;
        return Objects.equals(this.functionalAcknowledgmentAsString(), other.functionalAcknowledgmentAsString()) && Objects.equals(this.technicalAcknowledgmentAsString(), other.technicalAcknowledgmentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"X12AcknowledgmentOptions").add("FunctionalAcknowledgment", (Object)this.functionalAcknowledgmentAsString()).add("TechnicalAcknowledgment", (Object)this.technicalAcknowledgmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionalAcknowledgment": {
                return Optional.ofNullable(clazz.cast(this.functionalAcknowledgmentAsString()));
            }
            case "technicalAcknowledgment": {
                return Optional.ofNullable(clazz.cast(this.technicalAcknowledgmentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("functionalAcknowledgment", FUNCTIONAL_ACKNOWLEDGMENT_FIELD);
        map.put("technicalAcknowledgment", TECHNICAL_ACKNOWLEDGMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12AcknowledgmentOptions, T> g) {
        return obj -> g.apply((X12AcknowledgmentOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionalAcknowledgment;
        private String technicalAcknowledgment;

        private BuilderImpl() {
        }

        private BuilderImpl(X12AcknowledgmentOptions model) {
            this.functionalAcknowledgment(model.functionalAcknowledgment);
            this.technicalAcknowledgment(model.technicalAcknowledgment);
        }

        public final String getFunctionalAcknowledgment() {
            return this.functionalAcknowledgment;
        }

        public final void setFunctionalAcknowledgment(String functionalAcknowledgment) {
            this.functionalAcknowledgment = functionalAcknowledgment;
        }

        @Override
        public final Builder functionalAcknowledgment(String functionalAcknowledgment) {
            this.functionalAcknowledgment = functionalAcknowledgment;
            return this;
        }

        @Override
        public final Builder functionalAcknowledgment(X12FunctionalAcknowledgment functionalAcknowledgment) {
            this.functionalAcknowledgment(functionalAcknowledgment == null ? null : functionalAcknowledgment.toString());
            return this;
        }

        public final String getTechnicalAcknowledgment() {
            return this.technicalAcknowledgment;
        }

        public final void setTechnicalAcknowledgment(String technicalAcknowledgment) {
            this.technicalAcknowledgment = technicalAcknowledgment;
        }

        @Override
        public final Builder technicalAcknowledgment(String technicalAcknowledgment) {
            this.technicalAcknowledgment = technicalAcknowledgment;
            return this;
        }

        @Override
        public final Builder technicalAcknowledgment(X12TechnicalAcknowledgment technicalAcknowledgment) {
            this.technicalAcknowledgment(technicalAcknowledgment == null ? null : technicalAcknowledgment.toString());
            return this;
        }

        public X12AcknowledgmentOptions build() {
            return new X12AcknowledgmentOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12AcknowledgmentOptions> {
        public Builder functionalAcknowledgment(String var1);

        public Builder functionalAcknowledgment(X12FunctionalAcknowledgment var1);

        public Builder technicalAcknowledgment(String var1);

        public Builder technicalAcknowledgment(X12TechnicalAcknowledgment var1);
    }
}

