/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.Logging;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileSummary> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileId").getter(ProfileSummary.getter(ProfileSummary::profileId)).setter(ProfileSummary.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ProfileSummary.getter(ProfileSummary::name)).setter(ProfileSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("businessName").getter(ProfileSummary.getter(ProfileSummary::businessName)).setter(ProfileSummary.setter(Builder::businessName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessName").build()}).build();
    private static final SdkField<String> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logging").getter(ProfileSummary.getter(ProfileSummary::loggingAsString)).setter(ProfileSummary.setter(Builder::logging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(ProfileSummary.getter(ProfileSummary::logGroupName)).setter(ProfileSummary.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ProfileSummary.getter(ProfileSummary::createdAt)).setter(ProfileSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(ProfileSummary.getter(ProfileSummary::modifiedAt)).setter(ProfileSummary.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, NAME_FIELD, BUSINESS_NAME_FIELD, LOGGING_FIELD, LOG_GROUP_NAME_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProfileSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String profileId;
    private final String name;
    private final String businessName;
    private final String logging;
    private final String logGroupName;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private ProfileSummary(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.name = builder.name;
        this.businessName = builder.businessName;
        this.logging = builder.logging;
        this.logGroupName = builder.logGroupName;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String name() {
        return this.name;
    }

    public final String businessName() {
        return this.businessName;
    }

    public final Logging logging() {
        return Logging.fromValue(this.logging);
    }

    public final String loggingAsString() {
        return this.logging;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileSummary)) {
            return false;
        }
        ProfileSummary other = (ProfileSummary)obj;
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.businessName(), other.businessName()) && Objects.equals(this.loggingAsString(), other.loggingAsString()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileSummary").add("ProfileId", (Object)this.profileId()).add("Name", (Object)this.name()).add("BusinessName", (Object)this.businessName()).add("Logging", (Object)this.loggingAsString()).add("LogGroupName", (Object)this.logGroupName()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "businessName": {
                return Optional.ofNullable(clazz.cast(this.businessName()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.loggingAsString()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("businessName", BUSINESS_NAME_FIELD);
        map.put("logging", LOGGING_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileSummary, T> g) {
        return obj -> g.apply((ProfileSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileId;
        private String name;
        private String businessName;
        private String logging;
        private String logGroupName;
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileSummary model) {
            this.profileId(model.profileId);
            this.name(model.name);
            this.businessName(model.businessName);
            this.logging(model.logging);
            this.logGroupName(model.logGroupName);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBusinessName() {
            return this.businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final String getLogging() {
            return this.logging;
        }

        public final void setLogging(String logging) {
            this.logging = logging;
        }

        @Override
        public final Builder logging(String logging) {
            this.logging = logging;
            return this;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging(logging == null ? null : logging.toString());
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public ProfileSummary build() {
            return new ProfileSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileSummary> {
        public Builder profileId(String var1);

        public Builder name(String var1);

        public Builder businessName(String var1);

        public Builder logging(String var1);

        public Builder logging(Logging var1);

        public Builder logGroupName(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

