/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.X12ValidationRule;
import software.amazon.awssdk.services.b2bi.model.X12ValidationRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12ValidationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12ValidationOptions> {
    private static final SdkField<List<X12ValidationRule>> VALIDATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationRules").getter(X12ValidationOptions.getter(X12ValidationOptions::validationRules)).setter(X12ValidationOptions.setter(Builder::validationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(X12ValidationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = X12ValidationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<X12ValidationRule> validationRules;

    private X12ValidationOptions(BuilderImpl builder) {
        this.validationRules = builder.validationRules;
    }

    public final boolean hasValidationRules() {
        return this.validationRules != null && !(this.validationRules instanceof SdkAutoConstructList);
    }

    public final List<X12ValidationRule> validationRules() {
        return this.validationRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationRules() ? this.validationRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12ValidationOptions)) {
            return false;
        }
        X12ValidationOptions other = (X12ValidationOptions)obj;
        return this.hasValidationRules() == other.hasValidationRules() && Objects.equals(this.validationRules(), other.validationRules());
    }

    public final String toString() {
        return ToString.builder((String)"X12ValidationOptions").add("ValidationRules", this.hasValidationRules() ? this.validationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationRules": {
                return Optional.ofNullable(clazz.cast(this.validationRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<X12ValidationRule>>> map = new HashMap<String, SdkField<List<X12ValidationRule>>>();
        map.put("validationRules", VALIDATION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12ValidationOptions, T> g) {
        return obj -> g.apply((X12ValidationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<X12ValidationRule> validationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(X12ValidationOptions model) {
            this.validationRules(model.validationRules);
        }

        public final List<X12ValidationRule.Builder> getValidationRules() {
            List<X12ValidationRule.Builder> result = X12ValidationRulesCopier.copyToBuilder(this.validationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationRules(Collection<X12ValidationRule.BuilderImpl> validationRules) {
            this.validationRules = X12ValidationRulesCopier.copyFromBuilder(validationRules);
        }

        @Override
        public final Builder validationRules(Collection<X12ValidationRule> validationRules) {
            this.validationRules = X12ValidationRulesCopier.copy(validationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationRules(X12ValidationRule ... validationRules) {
            this.validationRules(Arrays.asList(validationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationRules(Consumer<X12ValidationRule.Builder> ... validationRules) {
            this.validationRules(Stream.of(validationRules).map(c -> (X12ValidationRule)((X12ValidationRule.Builder)X12ValidationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public X12ValidationOptions build() {
            return new X12ValidationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12ValidationOptions> {
        public Builder validationRules(Collection<X12ValidationRule> var1);

        public Builder validationRules(X12ValidationRule ... var1);

        public Builder validationRules(Consumer<X12ValidationRule.Builder> ... var1);
    }
}

