/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.LineTerminator;
import software.amazon.awssdk.services.b2bi.model.WrapFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WrapOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WrapOptions> {
    private static final SdkField<String> WRAP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("wrapBy").getter(WrapOptions.getter(WrapOptions::wrapByAsString)).setter(WrapOptions.setter(Builder::wrapBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wrapBy").build()}).build();
    private static final SdkField<String> LINE_TERMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lineTerminator").getter(WrapOptions.getter(WrapOptions::lineTerminatorAsString)).setter(WrapOptions.setter(Builder::lineTerminator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineTerminator").build()}).build();
    private static final SdkField<Integer> LINE_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("lineLength").getter(WrapOptions.getter(WrapOptions::lineLength)).setter(WrapOptions.setter(Builder::lineLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAP_BY_FIELD, LINE_TERMINATOR_FIELD, LINE_LENGTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WrapOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String wrapBy;
    private final String lineTerminator;
    private final Integer lineLength;

    private WrapOptions(BuilderImpl builder) {
        this.wrapBy = builder.wrapBy;
        this.lineTerminator = builder.lineTerminator;
        this.lineLength = builder.lineLength;
    }

    public final WrapFormat wrapBy() {
        return WrapFormat.fromValue(this.wrapBy);
    }

    public final String wrapByAsString() {
        return this.wrapBy;
    }

    public final LineTerminator lineTerminator() {
        return LineTerminator.fromValue(this.lineTerminator);
    }

    public final String lineTerminatorAsString() {
        return this.lineTerminator;
    }

    public final Integer lineLength() {
        return this.lineLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wrapByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineTerminatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrapOptions)) {
            return false;
        }
        WrapOptions other = (WrapOptions)obj;
        return Objects.equals(this.wrapByAsString(), other.wrapByAsString()) && Objects.equals(this.lineTerminatorAsString(), other.lineTerminatorAsString()) && Objects.equals(this.lineLength(), other.lineLength());
    }

    public final String toString() {
        return ToString.builder((String)"WrapOptions").add("WrapBy", (Object)this.wrapByAsString()).add("LineTerminator", (Object)this.lineTerminatorAsString()).add("LineLength", (Object)this.lineLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "wrapBy": {
                return Optional.ofNullable(clazz.cast(this.wrapByAsString()));
            }
            case "lineTerminator": {
                return Optional.ofNullable(clazz.cast(this.lineTerminatorAsString()));
            }
            case "lineLength": {
                return Optional.ofNullable(clazz.cast(this.lineLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("wrapBy", WRAP_BY_FIELD);
        map.put("lineTerminator", LINE_TERMINATOR_FIELD);
        map.put("lineLength", LINE_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WrapOptions, T> g) {
        return obj -> g.apply((WrapOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String wrapBy;
        private String lineTerminator;
        private Integer lineLength;

        private BuilderImpl() {
        }

        private BuilderImpl(WrapOptions model) {
            this.wrapBy(model.wrapBy);
            this.lineTerminator(model.lineTerminator);
            this.lineLength(model.lineLength);
        }

        public final String getWrapBy() {
            return this.wrapBy;
        }

        public final void setWrapBy(String wrapBy) {
            this.wrapBy = wrapBy;
        }

        @Override
        public final Builder wrapBy(String wrapBy) {
            this.wrapBy = wrapBy;
            return this;
        }

        @Override
        public final Builder wrapBy(WrapFormat wrapBy) {
            this.wrapBy(wrapBy == null ? null : wrapBy.toString());
            return this;
        }

        public final String getLineTerminator() {
            return this.lineTerminator;
        }

        public final void setLineTerminator(String lineTerminator) {
            this.lineTerminator = lineTerminator;
        }

        @Override
        public final Builder lineTerminator(String lineTerminator) {
            this.lineTerminator = lineTerminator;
            return this;
        }

        @Override
        public final Builder lineTerminator(LineTerminator lineTerminator) {
            this.lineTerminator(lineTerminator == null ? null : lineTerminator.toString());
            return this;
        }

        public final Integer getLineLength() {
            return this.lineLength;
        }

        public final void setLineLength(Integer lineLength) {
            this.lineLength = lineLength;
        }

        @Override
        public final Builder lineLength(Integer lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        public WrapOptions build() {
            return new WrapOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WrapOptions> {
        public Builder wrapBy(String var1);

        public Builder wrapBy(WrapFormat var1);

        public Builder lineTerminator(String var1);

        public Builder lineTerminator(LineTerminator var1);

        public Builder lineLength(Integer var1);
    }
}

