/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.b2bi.B2BiClient;
import software.amazon.awssdk.services.b2bi.internal.UserAgentUtils;
import software.amazon.awssdk.services.b2bi.model.ListTransformersRequest;
import software.amazon.awssdk.services.b2bi.model.ListTransformersResponse;
import software.amazon.awssdk.services.b2bi.model.TransformerSummary;

public class ListTransformersIterable
implements SdkIterable<ListTransformersResponse> {
    private final B2BiClient client;
    private final ListTransformersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTransformersIterable(B2BiClient client, ListTransformersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTransformersResponseFetcher();
    }

    public Iterator<ListTransformersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransformerSummary> transformers() {
        Function<ListTransformersResponse, Iterator> getIterator = response -> {
            if (response != null && response.transformers() != null) {
                return response.transformers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTransformersResponseFetcher
    implements SyncPageFetcher<ListTransformersResponse> {
        private ListTransformersResponseFetcher() {
        }

        public boolean hasNextPage(ListTransformersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTransformersResponse nextPage(ListTransformersResponse previousPage) {
            if (previousPage == null) {
                return ListTransformersIterable.this.client.listTransformers(ListTransformersIterable.this.firstRequest);
            }
            return ListTransformersIterable.this.client.listTransformers((ListTransformersRequest)((Object)ListTransformersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

