/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.unmarshall;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingKnownType;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.TraitType;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerContext;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerRegistry;
import software.amazon.awssdk.protocols.jsoncore.JsonValueNodeFactory;
import software.amazon.awssdk.thirdparty.jackson.core.JsonFactory;
import software.amazon.awssdk.thirdparty.jackson.core.JsonParseException;
import software.amazon.awssdk.thirdparty.jackson.core.JsonParser;
import software.amazon.awssdk.thirdparty.jackson.core.JsonToken;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.builder.Buildable;

@SdkInternalApi
@ThreadSafe
final class JsonUnmarshallingParser {
    private final JsonFactory jsonFactory;
    private final JsonValueNodeFactory jsonValueNodeFactory;
    private final JsonUnmarshallerRegistry unmarshallerRegistry;
    private final TimestampFormatTrait.Format defaultFormat;

    private JsonUnmarshallingParser(Builder builder) {
        this.jsonFactory = builder.jsonFactory;
        this.jsonValueNodeFactory = builder.jsonValueNodeFactory;
        this.unmarshallerRegistry = builder.unmarshallerRegistry;
        this.defaultFormat = builder.defaultFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SdkPojo parse(SdkPojo pojo, InputStream content) {
        return (SdkPojo)FunctionalUtils.invokeSafely(() -> {
            try (JsonParser parser = this.jsonFactory.createParser(content).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);){
                JsonUnmarshallerContext c = JsonUnmarshallerContext.builder().build();
                JsonToken token = parser.nextToken();
                if (token == null) {
                    SdkPojo sdkPojo = (SdkPojo)((Buildable)pojo).build();
                    return sdkPojo;
                }
                if (token == JsonToken.VALUE_NULL) {
                    SdkPojo sdkPojo = null;
                    return sdkPojo;
                }
                if (token != JsonToken.START_OBJECT) {
                    throw new JsonParseException("expecting start object, got instead: " + token);
                }
                SdkPojo sdkPojo = this.parseSdkPojo(c, pojo, parser);
                return sdkPojo;
            }
        });
    }

    private SdkPojo parseSdkPojo(JsonUnmarshallerContext c, SdkPojo pojo, JsonParser parser) throws IOException {
        Map pojoFields = pojo.sdkFieldNameToField();
        JsonToken currentToken = parser.nextToken();
        while (currentToken != JsonToken.END_OBJECT) {
            String fieldName = parser.getText();
            SdkField pojoField = (SdkField)pojoFields.get(fieldName);
            if (pojoField == null || !this.isPayloadUnmarshalling(pojoField.location())) {
                this.skipValue(parser, null);
                currentToken = parser.nextToken();
                continue;
            }
            currentToken = parser.nextToken();
            Object valueFor = this.valueFor(pojoField, c, pojoField.marshallingType(), parser, currentToken);
            pojoField.set((Object)pojo, valueFor);
            currentToken = parser.nextToken();
        }
        return (SdkPojo)((Buildable)pojo).build();
    }

    private boolean isPayloadUnmarshalling(MarshallLocation location) {
        switch (location) {
            case PAYLOAD: 
            case PATH: 
            case QUERY_PARAM: 
            case GREEDY_PATH: {
                return true;
            }
        }
        return false;
    }

    private List<Object> parseList(JsonUnmarshallerContext c, SdkField<?> field, JsonParser parser) throws IOException {
        SdkField memberInfo = ((ListTrait)field.getTrait(ListTrait.class)).memberFieldInfo();
        MarshallingType marshallingType = memberInfo.marshallingType();
        ArrayList<Object> result = new ArrayList<Object>();
        JsonToken currentToken = parser.nextToken();
        if (this.isScalarType(marshallingType)) {
            MarshallingKnownType marshallingKnownType = marshallingType.getKnownType();
            while (currentToken != JsonToken.END_ARRAY) {
                result.add(this.simpleValueFor(field, marshallingKnownType, c, parser, currentToken));
                currentToken = parser.nextToken();
            }
            return result;
        }
        while (currentToken != JsonToken.END_ARRAY) {
            result.add(this.valueFor(memberInfo, c, marshallingType, parser, currentToken));
            currentToken = parser.nextToken();
        }
        return result;
    }

    private Map<String, Object> parseMap(JsonUnmarshallerContext c, SdkField<?> field, JsonParser parser) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SdkField valueInfo = ((MapTrait)field.getTrait(MapTrait.class, TraitType.MAP_TRAIT)).valueFieldInfo();
        MarshallingType valueMarshallingType = valueInfo.marshallingType();
        JsonToken currentToken = parser.nextToken();
        if (this.isScalarType(valueMarshallingType)) {
            MarshallingKnownType valueMarshallingKnownType = valueMarshallingType.getKnownType();
            while (currentToken != JsonToken.END_OBJECT) {
                String fieldName = parser.getText();
                currentToken = parser.nextToken();
                Object valueFor = this.simpleValueFor(field, valueMarshallingKnownType, c, parser, currentToken);
                result.put(fieldName, valueFor);
                currentToken = parser.nextToken();
            }
            return result;
        }
        while (currentToken != JsonToken.END_OBJECT) {
            String fieldName = parser.getText();
            currentToken = parser.nextToken();
            Object valueFor = this.valueFor(valueInfo, c, valueMarshallingType, parser, currentToken);
            result.put(fieldName, valueFor);
            currentToken = parser.nextToken();
        }
        return result;
    }

    private Object valueFor(SdkField<?> field, JsonUnmarshallerContext context, MarshallingType<?> type, JsonParser parser, JsonToken lookAhead) throws IOException {
        MarshallingKnownType marshallingKnownType = type.getKnownType();
        if (marshallingKnownType == MarshallingKnownType.DOCUMENT) {
            return this.parseDocumentValue(context, parser, lookAhead);
        }
        if (lookAhead == JsonToken.VALUE_NULL) {
            if (marshallingKnownType == MarshallingKnownType.DOCUMENT) {
                return Document.fromNull();
            }
            return null;
        }
        switch (marshallingKnownType) {
            case DOCUMENT: {
                return this.parseDocumentValue(context, parser, lookAhead);
            }
            case SDK_POJO: {
                this.expect(lookAhead, JsonToken.START_OBJECT);
                return this.parseSdkPojo(context, (SdkPojo)field.constructor().get(), parser);
            }
            case LIST: {
                this.expect(lookAhead, JsonToken.START_ARRAY);
                return this.parseList(context, field, parser);
            }
            case MAP: {
                this.expect(lookAhead, JsonToken.START_OBJECT);
                return this.parseMap(context, field, parser);
            }
            case INSTANT: {
                return this.instantValueFor(field, parser, context, lookAhead);
            }
        }
        if (lookAhead == JsonToken.VALUE_STRING && marshallingKnownType != MarshallingKnownType.STRING && marshallingKnownType != MarshallingKnownType.SDK_BYTES) {
            JsonUnmarshaller<Object> unmarshaller = this.unmarshallerRegistry.getUnmarshaller(MarshallLocation.PAYLOAD, type);
            return unmarshaller.unmarshall(context, this.jsonValueNodeFactory.node(parser, lookAhead), field);
        }
        return this.simpleValueFor(field, marshallingKnownType, context, parser, lookAhead);
    }

    private Object simpleValueFor(SdkField<?> field, MarshallingKnownType knownType, JsonUnmarshallerContext context, JsonParser parser, JsonToken lookAhead) throws IOException {
        if (lookAhead == JsonToken.VALUE_NULL) {
            return null;
        }
        switch (knownType) {
            case INTEGER: {
                this.expect(lookAhead, JsonToken.VALUE_NUMBER_INT);
                return parser.getIntValue();
            }
            case LONG: {
                this.expect(lookAhead, JsonToken.VALUE_NUMBER_INT);
                return parser.getLongValue();
            }
            case SHORT: {
                this.expect(lookAhead, JsonToken.VALUE_NUMBER_INT);
                return parser.getShortValue();
            }
            case BYTE: {
                this.expect(lookAhead, JsonToken.VALUE_NUMBER_INT);
                return parser.getByteValue();
            }
            case FLOAT: {
                this.expect(lookAhead, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
                return Float.valueOf(parser.getFloatValue());
            }
            case DOUBLE: {
                this.expect(lookAhead, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
                return parser.getDoubleValue();
            }
            case BIG_DECIMAL: {
                this.expect(lookAhead, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
                return parser.getDecimalValue();
            }
            case BOOLEAN: {
                this.expect(lookAhead, JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE);
                return parser.getBooleanValue();
            }
            case INSTANT: {
                return this.instantValueFor(field, parser, context, lookAhead);
            }
            case STRING: {
                return parser.getText();
            }
            case SDK_BYTES: {
                if (lookAhead == JsonToken.VALUE_EMBEDDED_OBJECT) {
                    return SdkBytes.fromByteArray((byte[])((byte[])parser.getEmbeddedObject()));
                }
                this.expect(lookAhead, JsonToken.VALUE_STRING);
                return SdkBytes.fromByteArray((byte[])BinaryUtils.fromBase64((String)parser.getText()));
            }
        }
        throw new JsonParseException("unexpected token, expecting token for: " + knownType + ", got: " + lookAhead);
    }

    private void skipValue(JsonParser parser, JsonToken lookAhead) throws IOException {
        JsonToken current = lookAhead != null ? lookAhead : parser.nextToken();
        switch (current) {
            case VALUE_STRING: 
            case VALUE_FALSE: 
            case VALUE_TRUE: 
            case VALUE_NULL: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: 
            case VALUE_EMBEDDED_OBJECT: {
                return;
            }
            case START_OBJECT: {
                while ((current = parser.nextToken()) != JsonToken.END_OBJECT) {
                    this.skipValue(parser, null);
                }
                return;
            }
            case START_ARRAY: {
                while ((current = parser.nextToken()) != JsonToken.END_ARRAY) {
                    this.skipValue(parser, current);
                }
                return;
            }
        }
        throw new JsonParseException("unexpected JSON token - " + current);
    }

    private void expect(JsonToken lookAhead, JsonToken expected) throws IOException {
        if (lookAhead != expected) {
            throw new JsonParseException("unexpected token, expecting token: " + expected + ", got: " + lookAhead);
        }
    }

    private void expect(JsonToken lookAhead, JsonToken expected0, JsonToken expected1) throws IOException {
        if (lookAhead != expected0 && lookAhead != expected1) {
            throw new JsonParseException("unexpected token, expecting token: " + expected0 + ", or " + expected1 + ", got: " + lookAhead);
        }
    }

    private Instant instantValueFor(SdkField<?> field, JsonParser parser, JsonUnmarshallerContext context, JsonToken lookAhead) throws IOException {
        TimestampFormatTrait.Format format = this.resolveTimestampFormat(field);
        switch (format) {
            case UNIX_TIMESTAMP: {
                return Instant.ofEpochMilli((long)(parser.getDoubleValue() * 1000.0));
            }
            case UNIX_TIMESTAMP_MILLIS: {
                return Instant.ofEpochMilli(parser.getLongValue());
            }
        }
        JsonUnmarshaller<Object> unmarshaller = this.unmarshallerRegistry.getUnmarshaller(MarshallLocation.PAYLOAD, field.marshallingType());
        return (Instant)unmarshaller.unmarshall(context, this.jsonValueNodeFactory.node(parser, lookAhead), field);
    }

    private TimestampFormatTrait.Format resolveTimestampFormat(SdkField<?> field) {
        TimestampFormatTrait trait = (TimestampFormatTrait)field.getTrait(TimestampFormatTrait.class, TraitType.TIMESTAMP_FORMAT_TRAIT);
        if (trait == null) {
            return this.defaultFormat;
        }
        return trait.format();
    }

    private boolean isCompositeType(MarshallingType<?> marshallingType) {
        return marshallingType == MarshallingType.LIST || marshallingType == MarshallingType.MAP || marshallingType == MarshallingType.SDK_POJO || marshallingType == MarshallingType.DOCUMENT;
    }

    private boolean isScalarType(MarshallingType<?> marshallingType) {
        return !this.isCompositeType(marshallingType);
    }

    private Document parseDocumentValue(JsonUnmarshallerContext c, JsonParser parser, JsonToken lookAhead) throws IOException {
        JsonToken token = lookAhead != null ? lookAhead : parser.nextToken();
        switch (token) {
            case VALUE_STRING: {
                return Document.fromString((String)parser.getText());
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return Document.fromNumber((String)parser.getText());
            }
            case VALUE_FALSE: {
                return Document.fromBoolean((boolean)false);
            }
            case VALUE_TRUE: {
                return Document.fromBoolean((boolean)true);
            }
            case VALUE_NULL: {
                return Document.fromNull();
            }
            case START_ARRAY: {
                return this.parseDocumentList(c, parser);
            }
            case START_OBJECT: {
                return this.parseDocumentMap(c, parser);
            }
        }
        throw new JsonParseException("unexpected JSON token - " + token);
    }

    private Document parseDocumentList(JsonUnmarshallerContext c, JsonParser parser) throws IOException {
        Document.ListBuilder builder = Document.listBuilder();
        JsonToken currentToken = parser.nextToken();
        while (currentToken != JsonToken.END_ARRAY) {
            builder.addDocument(this.parseDocumentValue(c, parser, currentToken));
            currentToken = parser.nextToken();
        }
        return builder.build();
    }

    private Document parseDocumentMap(JsonUnmarshallerContext c, JsonParser parser) throws IOException {
        Document.MapBuilder builder = Document.mapBuilder();
        JsonToken currentToken = parser.nextToken();
        while (currentToken != JsonToken.END_OBJECT) {
            String key = parser.getText();
            Document value = this.parseDocumentValue(c, parser, null);
            builder.putDocument(key, value);
            currentToken = parser.nextToken();
        }
        return builder.build();
    }

    public static final class Builder {
        private JsonFactory jsonFactory;
        private JsonValueNodeFactory jsonValueNodeFactory = JsonValueNodeFactory.DEFAULT;
        private JsonUnmarshallerRegistry unmarshallerRegistry;
        private TimestampFormatTrait.Format defaultFormat;

        private Builder() {
        }

        public Builder jsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        public Builder jsonValueNodeFactory(JsonValueNodeFactory jsonValueNodeFactory) {
            this.jsonValueNodeFactory = jsonValueNodeFactory;
            return this;
        }

        public Builder unmarshallerRegistry(JsonUnmarshallerRegistry unmarshallerRegistry) {
            this.unmarshallerRegistry = unmarshallerRegistry;
            return this;
        }

        public Builder defaultTimestampFormat(TimestampFormatTrait.Format defaultFormat) {
            this.defaultFormat = defaultFormat;
            return this;
        }

        public JsonUnmarshallingParser build() {
            return new JsonUnmarshallingParser(this);
        }
    }
}

