/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.cbor;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.protocols.cbor.internal.AwsStructuredCborFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.DefaultJsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.JsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.StructuredJsonFactory;
import software.amazon.awssdk.protocols.json.internal.unmarshall.DefaultProtocolUnmarshallDependencies;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonProtocolUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.ProtocolUnmarshallDependencies;
import software.amazon.awssdk.protocols.jsoncore.JsonValueNodeFactory;
import software.amazon.awssdk.utils.Lazy;

@SdkProtectedApi
public final class AwsCborProtocolFactory
extends BaseAwsJsonProtocolFactory {
    private static final Lazy<ProtocolUnmarshallDependencies> PROTOCOL_UNMARSHALL_DEPENDENCIES_LAZY = new Lazy(AwsCborProtocolFactory::newProtocolUnmarshallDependencies);
    private static final JsonContentTypeResolver AWS_CBOR = new DefaultJsonContentTypeResolver("application/x-amz-cbor-");
    private final boolean isSdkSystemSettingCborEnabled;

    private AwsCborProtocolFactory(Builder builder) {
        super((BaseAwsJsonProtocolFactory.Builder)builder);
        this.isSdkSystemSettingCborEnabled = builder.isSdkSystemSettingCborEnabled;
    }

    protected JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return AWS_CBOR;
        }
        return AWS_JSON;
    }

    protected StructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return AwsStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        return super.getSdkFactory();
    }

    protected Map<MarshallLocation, TimestampFormatTrait.Format> getDefaultTimestampFormats() {
        if (!this.isCborEnabled()) {
            return super.getDefaultTimestampFormats();
        }
        EnumMap<MarshallLocation, TimestampFormatTrait.Format> formats = new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class);
        formats.put(MarshallLocation.HEADER, TimestampFormatTrait.Format.RFC_822);
        formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.UNIX_TIMESTAMP_MILLIS);
        return Collections.unmodifiableMap(formats);
    }

    private boolean isCborEnabled() {
        return this.isSdkSystemSettingCborEnabled;
    }

    private static boolean isSdkSystemSettingCborEnabled() {
        return SdkSystemSetting.CBOR_ENABLED.getBooleanValueOrThrow();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProtocolUnmarshallDependencies defaultProtocolUnmarshallDependencies() {
        return (ProtocolUnmarshallDependencies)PROTOCOL_UNMARSHALL_DEPENDENCIES_LAZY.getValue();
    }

    public static DefaultProtocolUnmarshallDependencies newProtocolUnmarshallDependencies() {
        return DefaultProtocolUnmarshallDependencies.builder().jsonUnmarshallerRegistry(JsonProtocolUnmarshaller.timestampFormatRegistryFactory(AwsCborProtocolFactory.defaultFormats())).nodeValueFactory(JsonValueNodeFactory.DEFAULT).timestampFormats(AwsCborProtocolFactory.defaultFormats()).jsonFactory(AwsStructuredCborFactory.SDK_CBOR_FACTORY.getJsonFactory()).build();
    }

    private static Map<MarshallLocation, TimestampFormatTrait.Format> defaultFormats() {
        EnumMap<MarshallLocation, TimestampFormatTrait.Format> formats = new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class);
        formats.put(MarshallLocation.HEADER, TimestampFormatTrait.Format.RFC_822);
        formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.UNIX_TIMESTAMP_MILLIS);
        return Collections.unmodifiableMap(formats);
    }

    static /* synthetic */ boolean access$200() {
        return AwsCborProtocolFactory.isSdkSystemSettingCborEnabled();
    }

    public static final class Builder
    extends BaseAwsJsonProtocolFactory.Builder<Builder> {
        private boolean isSdkSystemSettingCborEnabled = AwsCborProtocolFactory.access$200();

        private Builder() {
        }

        public AwsCborProtocolFactory build() {
            if (this.isSdkSystemSettingCborEnabled) {
                this.protocolUnmarshallDependencies(AwsCborProtocolFactory::defaultProtocolUnmarshallDependencies);
            } else {
                this.protocolUnmarshallDependencies(JsonProtocolUnmarshaller::defaultProtocolUnmarshallDependencies);
            }
            return new AwsCborProtocolFactory(this);
        }
    }
}

