/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansClient;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansServiceClientConfiguration;
import software.amazon.awssdk.services.autoscalingplans.internal.AutoScalingPlansServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansException;
import software.amazon.awssdk.services.autoscalingplans.model.ConcurrentUpdateException;
import software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse;
import software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest;
import software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse;
import software.amazon.awssdk.services.autoscalingplans.model.InternalServiceException;
import software.amazon.awssdk.services.autoscalingplans.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscalingplans.model.LimitExceededException;
import software.amazon.awssdk.services.autoscalingplans.model.ObjectNotFoundException;
import software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.ValidationException;
import software.amazon.awssdk.services.autoscalingplans.transform.CreateScalingPlanRequestMarshaller;
import software.amazon.awssdk.services.autoscalingplans.transform.DeleteScalingPlanRequestMarshaller;
import software.amazon.awssdk.services.autoscalingplans.transform.DescribeScalingPlanResourcesRequestMarshaller;
import software.amazon.awssdk.services.autoscalingplans.transform.DescribeScalingPlansRequestMarshaller;
import software.amazon.awssdk.services.autoscalingplans.transform.GetScalingPlanResourceForecastDataRequestMarshaller;
import software.amazon.awssdk.services.autoscalingplans.transform.UpdateScalingPlanRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAutoScalingPlansClient
implements AutoScalingPlansClient {
    private static final Logger log = Logger.loggerFor(DefaultAutoScalingPlansClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAutoScalingPlansClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Auto_Scaling_Plans#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateScalingPlanResponse createScalingPlan(CreateScalingPlanRequest createScalingPlanRequest) throws ValidationException, LimitExceededException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, AutoScalingPlansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScalingPlanResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ObjectNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConcurrentUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createScalingPlanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingPlansClient.resolveMetricPublishers(clientConfiguration, createScalingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling Plans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScalingPlan");
            CreateScalingPlanResponse createScalingPlanResponse = (CreateScalingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScalingPlan").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createScalingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateScalingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createScalingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingPlansClient.lambda$createScalingPlan$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScalingPlanResponse deleteScalingPlan(DeleteScalingPlanRequest deleteScalingPlanRequest) throws ValidationException, ObjectNotFoundException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, AutoScalingPlansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScalingPlanResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ObjectNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConcurrentUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScalingPlanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingPlansClient.resolveMetricPublishers(clientConfiguration, deleteScalingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling Plans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScalingPlan");
            DeleteScalingPlanResponse deleteScalingPlanResponse = (DeleteScalingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScalingPlan").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteScalingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScalingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteScalingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingPlansClient.lambda$deleteScalingPlan$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingPlanResourcesResponse describeScalingPlanResources(DescribeScalingPlanResourcesRequest describeScalingPlanResourcesRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, AutoScalingPlansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingPlanResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ObjectNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConcurrentUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScalingPlanResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingPlansClient.resolveMetricPublishers(clientConfiguration, describeScalingPlanResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling Plans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingPlanResources");
            DescribeScalingPlanResourcesResponse describeScalingPlanResourcesResponse = (DescribeScalingPlanResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingPlanResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeScalingPlanResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingPlanResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeScalingPlanResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingPlansClient.lambda$describeScalingPlanResources$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingPlansResponse describeScalingPlans(DescribeScalingPlansRequest describeScalingPlansRequest) throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException, AutoScalingPlansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingPlansResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ObjectNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConcurrentUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScalingPlansRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingPlansClient.resolveMetricPublishers(clientConfiguration, describeScalingPlansRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling Plans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingPlans");
            DescribeScalingPlansResponse describeScalingPlansResponse = (DescribeScalingPlansResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingPlans").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeScalingPlansRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingPlansRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeScalingPlansResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingPlansClient.lambda$describeScalingPlans$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetScalingPlanResourceForecastDataResponse getScalingPlanResourceForecastData(GetScalingPlanResourceForecastDataRequest getScalingPlanResourceForecastDataRequest) throws ValidationException, InternalServiceException, AwsServiceException, SdkClientException, AutoScalingPlansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetScalingPlanResourceForecastDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ObjectNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConcurrentUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getScalingPlanResourceForecastDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingPlansClient.resolveMetricPublishers(clientConfiguration, getScalingPlanResourceForecastDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling Plans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetScalingPlanResourceForecastData");
            GetScalingPlanResourceForecastDataResponse getScalingPlanResourceForecastDataResponse = (GetScalingPlanResourceForecastDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetScalingPlanResourceForecastData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getScalingPlanResourceForecastDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetScalingPlanResourceForecastDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getScalingPlanResourceForecastDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingPlansClient.lambda$getScalingPlanResourceForecastData$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScalingPlanResponse updateScalingPlan(UpdateScalingPlanRequest updateScalingPlanRequest) throws ValidationException, ConcurrentUpdateException, InternalServiceException, ObjectNotFoundException, AwsServiceException, SdkClientException, AutoScalingPlansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateScalingPlanResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "ObjectNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConcurrentUpdateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateScalingPlanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAutoScalingPlansClient.resolveMetricPublishers(clientConfiguration, updateScalingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling Plans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScalingPlan");
            UpdateScalingPlanResponse updateScalingPlanResponse = (UpdateScalingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScalingPlan").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateScalingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateScalingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateScalingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAutoScalingPlansClient.lambda$updateScalingPlan$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "autoscaling-plans";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AutoScalingPlansServiceClientConfigurationBuilder serviceConfigBuilder = new AutoScalingPlansServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AutoScalingPlansException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final AutoScalingPlansServiceClientConfiguration serviceClientConfiguration() {
        return new AutoScalingPlansServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateScalingPlan$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getScalingPlanResourceForecastData$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalingPlans$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalingPlanResources$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScalingPlan$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScalingPlan$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

