/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;

public class DescribeLoadBalancerTargetGroupsPublisher
implements SdkPublisher<DescribeLoadBalancerTargetGroupsResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeLoadBalancerTargetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLoadBalancerTargetGroupsPublisher(AutoScalingAsyncClient client, DescribeLoadBalancerTargetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLoadBalancerTargetGroupsPublisher(AutoScalingAsyncClient client, DescribeLoadBalancerTargetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLoadBalancerTargetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLoadBalancerTargetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeLoadBalancerTargetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeLoadBalancerTargetGroupsResponse> {
        private DescribeLoadBalancerTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancerTargetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLoadBalancerTargetGroupsResponse> nextPage(DescribeLoadBalancerTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancerTargetGroupsPublisher.this.client.describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsPublisher.this.firstRequest);
            }
            return DescribeLoadBalancerTargetGroupsPublisher.this.client.describeLoadBalancerTargetGroups((DescribeLoadBalancerTargetGroupsRequest)((Object)DescribeLoadBalancerTargetGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

