/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.CapacityForecast;
import software.amazon.awssdk.services.autoscaling.model.LoadForecast;
import software.amazon.awssdk.services.autoscaling.model.LoadForecastsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPredictiveScalingForecastResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, GetPredictiveScalingForecastResponse> {
    private static final SdkField<List<LoadForecast>> LOAD_FORECAST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadForecast").getter(GetPredictiveScalingForecastResponse.getter(GetPredictiveScalingForecastResponse::loadForecast)).setter(GetPredictiveScalingForecastResponse.setter(Builder::loadForecast)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadForecast").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadForecast::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CapacityForecast> CAPACITY_FORECAST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityForecast").getter(GetPredictiveScalingForecastResponse.getter(GetPredictiveScalingForecastResponse::capacityForecast)).setter(GetPredictiveScalingForecastResponse.setter(Builder::capacityForecast)).constructor(CapacityForecast::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityForecast").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(GetPredictiveScalingForecastResponse.getter(GetPredictiveScalingForecastResponse::updateTime)).setter(GetPredictiveScalingForecastResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_FORECAST_FIELD, CAPACITY_FORECAST_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPredictiveScalingForecastResponse.memberNameToFieldInitializer();
    private final List<LoadForecast> loadForecast;
    private final CapacityForecast capacityForecast;
    private final Instant updateTime;

    private GetPredictiveScalingForecastResponse(BuilderImpl builder) {
        super(builder);
        this.loadForecast = builder.loadForecast;
        this.capacityForecast = builder.capacityForecast;
        this.updateTime = builder.updateTime;
    }

    public final boolean hasLoadForecast() {
        return this.loadForecast != null && !(this.loadForecast instanceof SdkAutoConstructList);
    }

    public final List<LoadForecast> loadForecast() {
        return this.loadForecast;
    }

    public final CapacityForecast capacityForecast() {
        return this.capacityForecast;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadForecast() ? this.loadForecast() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityForecast());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPredictiveScalingForecastResponse)) {
            return false;
        }
        GetPredictiveScalingForecastResponse other = (GetPredictiveScalingForecastResponse)((Object)obj);
        return this.hasLoadForecast() == other.hasLoadForecast() && Objects.equals(this.loadForecast(), other.loadForecast()) && Objects.equals(this.capacityForecast(), other.capacityForecast()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetPredictiveScalingForecastResponse").add("LoadForecast", this.hasLoadForecast() ? this.loadForecast() : null).add("CapacityForecast", (Object)this.capacityForecast()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadForecast": {
                return Optional.ofNullable(clazz.cast(this.loadForecast()));
            }
            case "CapacityForecast": {
                return Optional.ofNullable(clazz.cast(this.capacityForecast()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadForecast", LOAD_FORECAST_FIELD);
        map.put("CapacityForecast", CAPACITY_FORECAST_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPredictiveScalingForecastResponse, T> g) {
        return obj -> g.apply((GetPredictiveScalingForecastResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<LoadForecast> loadForecast = DefaultSdkAutoConstructList.getInstance();
        private CapacityForecast capacityForecast;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPredictiveScalingForecastResponse model) {
            super(model);
            this.loadForecast(model.loadForecast);
            this.capacityForecast(model.capacityForecast);
            this.updateTime(model.updateTime);
        }

        public final List<LoadForecast.Builder> getLoadForecast() {
            List<LoadForecast.Builder> result = LoadForecastsCopier.copyToBuilder(this.loadForecast);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadForecast(Collection<LoadForecast.BuilderImpl> loadForecast) {
            this.loadForecast = LoadForecastsCopier.copyFromBuilder(loadForecast);
        }

        @Override
        public final Builder loadForecast(Collection<LoadForecast> loadForecast) {
            this.loadForecast = LoadForecastsCopier.copy(loadForecast);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadForecast(LoadForecast ... loadForecast) {
            this.loadForecast(Arrays.asList(loadForecast));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadForecast(Consumer<LoadForecast.Builder> ... loadForecast) {
            this.loadForecast(Stream.of(loadForecast).map(c -> (LoadForecast)((LoadForecast.Builder)LoadForecast.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CapacityForecast.Builder getCapacityForecast() {
            return this.capacityForecast != null ? this.capacityForecast.toBuilder() : null;
        }

        public final void setCapacityForecast(CapacityForecast.BuilderImpl capacityForecast) {
            this.capacityForecast = capacityForecast != null ? capacityForecast.build() : null;
        }

        @Override
        public final Builder capacityForecast(CapacityForecast capacityForecast) {
            this.capacityForecast = capacityForecast;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetPredictiveScalingForecastResponse build() {
            return new GetPredictiveScalingForecastResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPredictiveScalingForecastResponse> {
        public Builder loadForecast(Collection<LoadForecast> var1);

        public Builder loadForecast(LoadForecast ... var1);

        public Builder loadForecast(Consumer<LoadForecast.Builder> ... var1);

        public Builder capacityForecast(CapacityForecast var1);

        default public Builder capacityForecast(Consumer<CapacityForecast.Builder> capacityForecast) {
            return this.capacityForecast((CapacityForecast)((CapacityForecast.Builder)CapacityForecast.builder().applyMutation(capacityForecast)).build());
        }

        public Builder updateTime(Instant var1);
    }
}

