/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials.internal;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkInternalApi
public final class Ec2MetadataDisableV1Resolver {
    private final Supplier<ProfileFile> profileFile;
    private final String profileName;
    private final Lazy<Boolean> resolvedValue;

    private Ec2MetadataDisableV1Resolver(Supplier<ProfileFile> profileFile, String profileName) {
        this.profileFile = profileFile;
        this.profileName = profileName;
        this.resolvedValue = new Lazy(this::doResolve);
    }

    public static Ec2MetadataDisableV1Resolver create(Supplier<ProfileFile> profileFile, String profileName) {
        return new Ec2MetadataDisableV1Resolver(profileFile, profileName);
    }

    public boolean resolve() {
        return (Boolean)this.resolvedValue.getValue();
    }

    public boolean doResolve() {
        return OptionalUtils.firstPresent(Ec2MetadataDisableV1Resolver.fromSystemSettings(), (Supplier[])new Supplier[]{() -> Ec2MetadataDisableV1Resolver.fromProfileFile(this.profileFile, this.profileName)}).orElse(false);
    }

    private static Optional<Boolean> fromSystemSettings() {
        return SdkSystemSetting.AWS_EC2_METADATA_V1_DISABLED.getBooleanValue();
    }

    private static Optional<Boolean> fromProfileFile(Supplier<ProfileFile> profileFile, String profileName) {
        return profileFile.get().profile(profileName).flatMap(p -> p.booleanProperty("ec2_metadata_v1_disabled"));
    }
}

