/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination;
import software.amazon.awssdk.services.auditmanager.model.DefaultExportDestination;
import software.amazon.awssdk.services.auditmanager.model.DeregistrationPolicy;
import software.amazon.awssdk.services.auditmanager.model.EvidenceFinderEnablement;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.services.auditmanager.model.RolesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Settings> {
    private static final SdkField<Boolean> IS_AWS_ORG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAwsOrgEnabled").getter(Settings.getter(Settings::isAwsOrgEnabled)).setter(Settings.setter(Builder::isAwsOrgEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAwsOrgEnabled").build()}).build();
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsTopic").getter(Settings.getter(Settings::snsTopic)).setter(Settings.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopic").build()}).build();
    private static final SdkField<AssessmentReportsDestination> DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAssessmentReportsDestination").getter(Settings.getter(Settings::defaultAssessmentReportsDestination)).setter(Settings.setter(Builder::defaultAssessmentReportsDestination)).constructor(AssessmentReportsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAssessmentReportsDestination").build()}).build();
    private static final SdkField<List<Role>> DEFAULT_PROCESS_OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultProcessOwners").getter(Settings.getter(Settings::defaultProcessOwners)).setter(Settings.setter(Builder::defaultProcessOwners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultProcessOwners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKey").getter(Settings.getter(Settings::kmsKey)).setter(Settings.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()}).build();
    private static final SdkField<EvidenceFinderEnablement> EVIDENCE_FINDER_ENABLEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evidenceFinderEnablement").getter(Settings.getter(Settings::evidenceFinderEnablement)).setter(Settings.setter(Builder::evidenceFinderEnablement)).constructor(EvidenceFinderEnablement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFinderEnablement").build()}).build();
    private static final SdkField<DeregistrationPolicy> DEREGISTRATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deregistrationPolicy").getter(Settings.getter(Settings::deregistrationPolicy)).setter(Settings.setter(Builder::deregistrationPolicy)).constructor(DeregistrationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deregistrationPolicy").build()}).build();
    private static final SdkField<DefaultExportDestination> DEFAULT_EXPORT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultExportDestination").getter(Settings.getter(Settings::defaultExportDestination)).setter(Settings.setter(Builder::defaultExportDestination)).constructor(DefaultExportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultExportDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_AWS_ORG_ENABLED_FIELD, SNS_TOPIC_FIELD, DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD, DEFAULT_PROCESS_OWNERS_FIELD, KMS_KEY_FIELD, EVIDENCE_FINDER_ENABLEMENT_FIELD, DEREGISTRATION_POLICY_FIELD, DEFAULT_EXPORT_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Settings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isAwsOrgEnabled;
    private final String snsTopic;
    private final AssessmentReportsDestination defaultAssessmentReportsDestination;
    private final List<Role> defaultProcessOwners;
    private final String kmsKey;
    private final EvidenceFinderEnablement evidenceFinderEnablement;
    private final DeregistrationPolicy deregistrationPolicy;
    private final DefaultExportDestination defaultExportDestination;

    private Settings(BuilderImpl builder) {
        this.isAwsOrgEnabled = builder.isAwsOrgEnabled;
        this.snsTopic = builder.snsTopic;
        this.defaultAssessmentReportsDestination = builder.defaultAssessmentReportsDestination;
        this.defaultProcessOwners = builder.defaultProcessOwners;
        this.kmsKey = builder.kmsKey;
        this.evidenceFinderEnablement = builder.evidenceFinderEnablement;
        this.deregistrationPolicy = builder.deregistrationPolicy;
        this.defaultExportDestination = builder.defaultExportDestination;
    }

    public final Boolean isAwsOrgEnabled() {
        return this.isAwsOrgEnabled;
    }

    public final String snsTopic() {
        return this.snsTopic;
    }

    public final AssessmentReportsDestination defaultAssessmentReportsDestination() {
        return this.defaultAssessmentReportsDestination;
    }

    public final boolean hasDefaultProcessOwners() {
        return this.defaultProcessOwners != null && !(this.defaultProcessOwners instanceof SdkAutoConstructList);
    }

    public final List<Role> defaultProcessOwners() {
        return this.defaultProcessOwners;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final EvidenceFinderEnablement evidenceFinderEnablement() {
        return this.evidenceFinderEnablement;
    }

    public final DeregistrationPolicy deregistrationPolicy() {
        return this.deregistrationPolicy;
    }

    public final DefaultExportDestination defaultExportDestination() {
        return this.defaultExportDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isAwsOrgEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAssessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultProcessOwners() ? this.defaultProcessOwners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceFinderEnablement());
        hashCode = 31 * hashCode + Objects.hashCode(this.deregistrationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultExportDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)obj;
        return Objects.equals(this.isAwsOrgEnabled(), other.isAwsOrgEnabled()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.defaultAssessmentReportsDestination(), other.defaultAssessmentReportsDestination()) && this.hasDefaultProcessOwners() == other.hasDefaultProcessOwners() && Objects.equals(this.defaultProcessOwners(), other.defaultProcessOwners()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.evidenceFinderEnablement(), other.evidenceFinderEnablement()) && Objects.equals(this.deregistrationPolicy(), other.deregistrationPolicy()) && Objects.equals(this.defaultExportDestination(), other.defaultExportDestination());
    }

    public final String toString() {
        return ToString.builder((String)"Settings").add("IsAwsOrgEnabled", (Object)this.isAwsOrgEnabled()).add("SnsTopic", (Object)(this.snsTopic() == null ? null : "*** Sensitive Data Redacted ***")).add("DefaultAssessmentReportsDestination", (Object)(this.defaultAssessmentReportsDestination() == null ? null : "*** Sensitive Data Redacted ***")).add("DefaultProcessOwners", (Object)(this.defaultProcessOwners() == null ? null : "*** Sensitive Data Redacted ***")).add("KmsKey", (Object)this.kmsKey()).add("EvidenceFinderEnablement", (Object)this.evidenceFinderEnablement()).add("DeregistrationPolicy", (Object)this.deregistrationPolicy()).add("DefaultExportDestination", (Object)this.defaultExportDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isAwsOrgEnabled": {
                return Optional.ofNullable(clazz.cast(this.isAwsOrgEnabled()));
            }
            case "snsTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "defaultAssessmentReportsDestination": {
                return Optional.ofNullable(clazz.cast(this.defaultAssessmentReportsDestination()));
            }
            case "defaultProcessOwners": {
                return Optional.ofNullable(clazz.cast(this.defaultProcessOwners()));
            }
            case "kmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "evidenceFinderEnablement": {
                return Optional.ofNullable(clazz.cast(this.evidenceFinderEnablement()));
            }
            case "deregistrationPolicy": {
                return Optional.ofNullable(clazz.cast(this.deregistrationPolicy()));
            }
            case "defaultExportDestination": {
                return Optional.ofNullable(clazz.cast(this.defaultExportDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isAwsOrgEnabled", IS_AWS_ORG_ENABLED_FIELD);
        map.put("snsTopic", SNS_TOPIC_FIELD);
        map.put("defaultAssessmentReportsDestination", DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD);
        map.put("defaultProcessOwners", DEFAULT_PROCESS_OWNERS_FIELD);
        map.put("kmsKey", KMS_KEY_FIELD);
        map.put("evidenceFinderEnablement", EVIDENCE_FINDER_ENABLEMENT_FIELD);
        map.put("deregistrationPolicy", DEREGISTRATION_POLICY_FIELD);
        map.put("defaultExportDestination", DEFAULT_EXPORT_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Settings, T> g) {
        return obj -> g.apply((Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isAwsOrgEnabled;
        private String snsTopic;
        private AssessmentReportsDestination defaultAssessmentReportsDestination;
        private List<Role> defaultProcessOwners = DefaultSdkAutoConstructList.getInstance();
        private String kmsKey;
        private EvidenceFinderEnablement evidenceFinderEnablement;
        private DeregistrationPolicy deregistrationPolicy;
        private DefaultExportDestination defaultExportDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(Settings model) {
            this.isAwsOrgEnabled(model.isAwsOrgEnabled);
            this.snsTopic(model.snsTopic);
            this.defaultAssessmentReportsDestination(model.defaultAssessmentReportsDestination);
            this.defaultProcessOwners(model.defaultProcessOwners);
            this.kmsKey(model.kmsKey);
            this.evidenceFinderEnablement(model.evidenceFinderEnablement);
            this.deregistrationPolicy(model.deregistrationPolicy);
            this.defaultExportDestination(model.defaultExportDestination);
        }

        public final Boolean getIsAwsOrgEnabled() {
            return this.isAwsOrgEnabled;
        }

        public final void setIsAwsOrgEnabled(Boolean isAwsOrgEnabled) {
            this.isAwsOrgEnabled = isAwsOrgEnabled;
        }

        @Override
        public final Builder isAwsOrgEnabled(Boolean isAwsOrgEnabled) {
            this.isAwsOrgEnabled = isAwsOrgEnabled;
            return this;
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final AssessmentReportsDestination.Builder getDefaultAssessmentReportsDestination() {
            return this.defaultAssessmentReportsDestination != null ? this.defaultAssessmentReportsDestination.toBuilder() : null;
        }

        public final void setDefaultAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination != null ? defaultAssessmentReportsDestination.build() : null;
        }

        @Override
        public final Builder defaultAssessmentReportsDestination(AssessmentReportsDestination defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination;
            return this;
        }

        public final List<Role.Builder> getDefaultProcessOwners() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.defaultProcessOwners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultProcessOwners(Collection<Role.BuilderImpl> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copyFromBuilder(defaultProcessOwners);
        }

        @Override
        public final Builder defaultProcessOwners(Collection<Role> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copy(defaultProcessOwners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Role ... defaultProcessOwners) {
            this.defaultProcessOwners(Arrays.asList(defaultProcessOwners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Consumer<Role.Builder> ... defaultProcessOwners) {
            this.defaultProcessOwners(Stream.of(defaultProcessOwners).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final EvidenceFinderEnablement.Builder getEvidenceFinderEnablement() {
            return this.evidenceFinderEnablement != null ? this.evidenceFinderEnablement.toBuilder() : null;
        }

        public final void setEvidenceFinderEnablement(EvidenceFinderEnablement.BuilderImpl evidenceFinderEnablement) {
            this.evidenceFinderEnablement = evidenceFinderEnablement != null ? evidenceFinderEnablement.build() : null;
        }

        @Override
        public final Builder evidenceFinderEnablement(EvidenceFinderEnablement evidenceFinderEnablement) {
            this.evidenceFinderEnablement = evidenceFinderEnablement;
            return this;
        }

        public final DeregistrationPolicy.Builder getDeregistrationPolicy() {
            return this.deregistrationPolicy != null ? this.deregistrationPolicy.toBuilder() : null;
        }

        public final void setDeregistrationPolicy(DeregistrationPolicy.BuilderImpl deregistrationPolicy) {
            this.deregistrationPolicy = deregistrationPolicy != null ? deregistrationPolicy.build() : null;
        }

        @Override
        public final Builder deregistrationPolicy(DeregistrationPolicy deregistrationPolicy) {
            this.deregistrationPolicy = deregistrationPolicy;
            return this;
        }

        public final DefaultExportDestination.Builder getDefaultExportDestination() {
            return this.defaultExportDestination != null ? this.defaultExportDestination.toBuilder() : null;
        }

        public final void setDefaultExportDestination(DefaultExportDestination.BuilderImpl defaultExportDestination) {
            this.defaultExportDestination = defaultExportDestination != null ? defaultExportDestination.build() : null;
        }

        @Override
        public final Builder defaultExportDestination(DefaultExportDestination defaultExportDestination) {
            this.defaultExportDestination = defaultExportDestination;
            return this;
        }

        public Settings build() {
            return new Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Settings> {
        public Builder isAwsOrgEnabled(Boolean var1);

        public Builder snsTopic(String var1);

        public Builder defaultAssessmentReportsDestination(AssessmentReportsDestination var1);

        default public Builder defaultAssessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> defaultAssessmentReportsDestination) {
            return this.defaultAssessmentReportsDestination((AssessmentReportsDestination)((AssessmentReportsDestination.Builder)AssessmentReportsDestination.builder().applyMutation(defaultAssessmentReportsDestination)).build());
        }

        public Builder defaultProcessOwners(Collection<Role> var1);

        public Builder defaultProcessOwners(Role ... var1);

        public Builder defaultProcessOwners(Consumer<Role.Builder> ... var1);

        public Builder kmsKey(String var1);

        public Builder evidenceFinderEnablement(EvidenceFinderEnablement var1);

        default public Builder evidenceFinderEnablement(Consumer<EvidenceFinderEnablement.Builder> evidenceFinderEnablement) {
            return this.evidenceFinderEnablement((EvidenceFinderEnablement)((EvidenceFinderEnablement.Builder)EvidenceFinderEnablement.builder().applyMutation(evidenceFinderEnablement)).build());
        }

        public Builder deregistrationPolicy(DeregistrationPolicy var1);

        default public Builder deregistrationPolicy(Consumer<DeregistrationPolicy.Builder> deregistrationPolicy) {
            return this.deregistrationPolicy((DeregistrationPolicy)((DeregistrationPolicy.Builder)DeregistrationPolicy.builder().applyMutation(deregistrationPolicy)).build());
        }

        public Builder defaultExportDestination(DefaultExportDestination var1);

        default public Builder defaultExportDestination(Consumer<DefaultExportDestination.Builder> defaultExportDestination) {
            return this.defaultExportDestination((DefaultExportDestination)((DefaultExportDestination.Builder)DefaultExportDestination.builder().applyMutation(defaultExportDestination)).build());
        }
    }
}

