/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.RoleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Role
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Role> {
    private static final SdkField<String> ROLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleType").getter(Role.getter(Role::roleTypeAsString)).setter(Role.setter(Builder::roleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Role.getter(Role::roleArn)).setter(Role.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_TYPE_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleType;
    private final String roleArn;

    private Role(BuilderImpl builder) {
        this.roleType = builder.roleType;
        this.roleArn = builder.roleArn;
    }

    public final RoleType roleType() {
        return RoleType.fromValue(this.roleType);
    }

    public final String roleTypeAsString() {
        return this.roleType;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return Objects.equals(this.roleTypeAsString(), other.roleTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"Role").add("RoleType", (Object)this.roleTypeAsString()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleType": {
                return Optional.ofNullable(clazz.cast(this.roleTypeAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Role, T> g) {
        return obj -> g.apply((Role)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleType;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Role model) {
            this.roleType(model.roleType);
            this.roleArn(model.roleArn);
        }

        public final String getRoleType() {
            return this.roleType;
        }

        public final void setRoleType(String roleType) {
            this.roleType = roleType;
        }

        @Override
        public final Builder roleType(String roleType) {
            this.roleType = roleType;
            return this;
        }

        @Override
        public final Builder roleType(RoleType roleType) {
            this.roleType(roleType == null ? null : roleType.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public Role build() {
            return new Role(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Role> {
        public Builder roleType(String var1);

        public Builder roleType(RoleType var1);

        public Builder roleArn(String var1);
    }
}

