/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterAccountRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, RegisterAccountRequest> {
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKey").getter(RegisterAccountRequest.getter(RegisterAccountRequest::kmsKey)).setter(RegisterAccountRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()}).build();
    private static final SdkField<String> DELEGATED_ADMIN_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("delegatedAdminAccount").getter(RegisterAccountRequest.getter(RegisterAccountRequest::delegatedAdminAccount)).setter(RegisterAccountRequest.setter(Builder::delegatedAdminAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegatedAdminAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_FIELD, DELEGATED_ADMIN_ACCOUNT_FIELD));
    private final String kmsKey;
    private final String delegatedAdminAccount;

    private RegisterAccountRequest(BuilderImpl builder) {
        super(builder);
        this.kmsKey = builder.kmsKey;
        this.delegatedAdminAccount = builder.delegatedAdminAccount;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String delegatedAdminAccount() {
        return this.delegatedAdminAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegatedAdminAccount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAccountRequest)) {
            return false;
        }
        RegisterAccountRequest other = (RegisterAccountRequest)((Object)obj);
        return Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.delegatedAdminAccount(), other.delegatedAdminAccount());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterAccountRequest").add("KmsKey", (Object)this.kmsKey()).add("DelegatedAdminAccount", (Object)this.delegatedAdminAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "delegatedAdminAccount": {
                return Optional.ofNullable(clazz.cast(this.delegatedAdminAccount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAccountRequest, T> g) {
        return obj -> g.apply((RegisterAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String kmsKey;
        private String delegatedAdminAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAccountRequest model) {
            super(model);
            this.kmsKey(model.kmsKey);
            this.delegatedAdminAccount(model.delegatedAdminAccount);
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getDelegatedAdminAccount() {
            return this.delegatedAdminAccount;
        }

        public final void setDelegatedAdminAccount(String delegatedAdminAccount) {
            this.delegatedAdminAccount = delegatedAdminAccount;
        }

        @Override
        public final Builder delegatedAdminAccount(String delegatedAdminAccount) {
            this.delegatedAdminAccount = delegatedAdminAccount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAccountRequest build() {
            return new RegisterAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterAccountRequest> {
        public Builder kmsKey(String var1);

        public Builder delegatedAdminAccount(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

