/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.KeywordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeywordsForDataSourceResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ListKeywordsForDataSourceResponse> {
    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keywords").getter(ListKeywordsForDataSourceResponse.getter(ListKeywordsForDataSourceResponse::keywords)).setter(ListKeywordsForDataSourceResponse.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKeywordsForDataSourceResponse.getter(ListKeywordsForDataSourceResponse::nextToken)).setter(ListKeywordsForDataSourceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYWORDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> keywords;
    private final String nextToken;

    private ListKeywordsForDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.keywords = builder.keywords;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasKeywords() {
        return this.keywords != null && !(this.keywords instanceof SdkAutoConstructList);
    }

    public final List<String> keywords() {
        return this.keywords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeywords() ? this.keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeywordsForDataSourceResponse)) {
            return false;
        }
        ListKeywordsForDataSourceResponse other = (ListKeywordsForDataSourceResponse)((Object)obj);
        return this.hasKeywords() == other.hasKeywords() && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKeywordsForDataSourceResponse").add("Keywords", this.hasKeywords() ? this.keywords() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKeywordsForDataSourceResponse, T> g) {
        return obj -> g.apply((ListKeywordsForDataSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeywordsForDataSourceResponse model) {
            super(model);
            this.keywords(model.keywords);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getKeywords() {
            if (this.keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keywords;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = KeywordsCopier.copy(keywords);
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = KeywordsCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String ... keywords) {
            this.keywords(Arrays.asList(keywords));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKeywordsForDataSourceResponse build() {
            return new ListKeywordsForDataSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKeywordsForDataSourceResponse> {
        public Builder keywords(Collection<String> var1);

        public Builder keywords(String ... var1);

        public Builder nextToken(String var1);
    }
}

