/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportMetadata;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportsMetadataCopier;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentReportsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ListAssessmentReportsResponse> {
    private static final SdkField<List<AssessmentReportMetadata>> ASSESSMENT_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentReports").getter(ListAssessmentReportsResponse.getter(ListAssessmentReportsResponse::assessmentReports)).setter(ListAssessmentReportsResponse.setter(Builder::assessmentReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentReportMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentReportsResponse.getter(ListAssessmentReportsResponse::nextToken)).setter(ListAssessmentReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_REPORTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssessmentReportMetadata> assessmentReports;
    private final String nextToken;

    private ListAssessmentReportsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentReports = builder.assessmentReports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessmentReports() {
        return this.assessmentReports != null && !(this.assessmentReports instanceof SdkAutoConstructList);
    }

    public final List<AssessmentReportMetadata> assessmentReports() {
        return this.assessmentReports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentReports() ? this.assessmentReports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentReportsResponse)) {
            return false;
        }
        ListAssessmentReportsResponse other = (ListAssessmentReportsResponse)((Object)obj);
        return this.hasAssessmentReports() == other.hasAssessmentReports() && Objects.equals(this.assessmentReports(), other.assessmentReports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssessmentReportsResponse").add("AssessmentReports", this.hasAssessmentReports() ? this.assessmentReports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentReports": {
                return Optional.ofNullable(clazz.cast(this.assessmentReports()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentReportsResponse, T> g) {
        return obj -> g.apply((ListAssessmentReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<AssessmentReportMetadata> assessmentReports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentReportsResponse model) {
            super(model);
            this.assessmentReports(model.assessmentReports);
            this.nextToken(model.nextToken);
        }

        public final List<AssessmentReportMetadata.Builder> getAssessmentReports() {
            List<AssessmentReportMetadata.Builder> result = AssessmentReportsMetadataCopier.copyToBuilder(this.assessmentReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentReports(Collection<AssessmentReportMetadata.BuilderImpl> assessmentReports) {
            this.assessmentReports = AssessmentReportsMetadataCopier.copyFromBuilder(assessmentReports);
        }

        @Override
        @Transient
        public final Builder assessmentReports(Collection<AssessmentReportMetadata> assessmentReports) {
            this.assessmentReports = AssessmentReportsMetadataCopier.copy(assessmentReports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assessmentReports(AssessmentReportMetadata ... assessmentReports) {
            this.assessmentReports(Arrays.asList(assessmentReports));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assessmentReports(Consumer<AssessmentReportMetadata.Builder> ... assessmentReports) {
            this.assessmentReports(Stream.of(assessmentReports).map(c -> (AssessmentReportMetadata)((AssessmentReportMetadata.Builder)AssessmentReportMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentReportsResponse build() {
            return new ListAssessmentReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentReportsResponse> {
        public Builder assessmentReports(Collection<AssessmentReportMetadata> var1);

        public Builder assessmentReports(AssessmentReportMetadata ... var1);

        public Builder assessmentReports(Consumer<AssessmentReportMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

