/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.Evidence;
import software.amazon.awssdk.services.auditmanager.model.EvidenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEvidenceByEvidenceFolderResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, GetEvidenceByEvidenceFolderResponse> {
    private static final SdkField<List<Evidence>> EVIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evidence").getter(GetEvidenceByEvidenceFolderResponse.getter(GetEvidenceByEvidenceFolderResponse::evidence)).setter(GetEvidenceByEvidenceFolderResponse.setter(Builder::evidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidence").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Evidence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetEvidenceByEvidenceFolderResponse.getter(GetEvidenceByEvidenceFolderResponse::nextToken)).setter(GetEvidenceByEvidenceFolderResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_FIELD, NEXT_TOKEN_FIELD));
    private final List<Evidence> evidence;
    private final String nextToken;

    private GetEvidenceByEvidenceFolderResponse(BuilderImpl builder) {
        super(builder);
        this.evidence = builder.evidence;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEvidence() {
        return this.evidence != null && !(this.evidence instanceof SdkAutoConstructList);
    }

    public final List<Evidence> evidence() {
        return this.evidence;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvidence() ? this.evidence() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceByEvidenceFolderResponse)) {
            return false;
        }
        GetEvidenceByEvidenceFolderResponse other = (GetEvidenceByEvidenceFolderResponse)((Object)obj);
        return this.hasEvidence() == other.hasEvidence() && Objects.equals(this.evidence(), other.evidence()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetEvidenceByEvidenceFolderResponse").add("Evidence", this.hasEvidence() ? this.evidence() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evidence": {
                return Optional.ofNullable(clazz.cast(this.evidence()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceByEvidenceFolderResponse, T> g) {
        return obj -> g.apply((GetEvidenceByEvidenceFolderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<Evidence> evidence = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceByEvidenceFolderResponse model) {
            super(model);
            this.evidence(model.evidence);
            this.nextToken(model.nextToken);
        }

        public final List<Evidence.Builder> getEvidence() {
            List<Evidence.Builder> result = EvidenceListCopier.copyToBuilder(this.evidence);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvidence(Collection<Evidence.BuilderImpl> evidence) {
            this.evidence = EvidenceListCopier.copyFromBuilder(evidence);
        }

        @Override
        @Transient
        public final Builder evidence(Collection<Evidence> evidence) {
            this.evidence = EvidenceListCopier.copy(evidence);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evidence(Evidence ... evidence) {
            this.evidence(Arrays.asList(evidence));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evidence(Consumer<Evidence.Builder> ... evidence) {
            this.evidence(Stream.of(evidence).map(c -> (Evidence)((Evidence.Builder)Evidence.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetEvidenceByEvidenceFolderResponse build() {
            return new GetEvidenceByEvidenceFolderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEvidenceByEvidenceFolderResponse> {
        public Builder evidence(Collection<Evidence> var1);

        public Builder evidence(Evidence ... var1);

        public Builder evidence(Consumer<Evidence.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

