/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateControlRequest extends AuditManagerRequest implements
        ToCopyableBuilder<UpdateControlRequest.Builder, UpdateControlRequest> {
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlId").getter(getter(UpdateControlRequest::controlId)).setter(setter(Builder::controlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateControlRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateControlRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TESTING_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testingInformation").getter(getter(UpdateControlRequest::testingInformation))
            .setter(setter(Builder::testingInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testingInformation").build())
            .build();

    private static final SdkField<String> ACTION_PLAN_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionPlanTitle").getter(getter(UpdateControlRequest::actionPlanTitle))
            .setter(setter(Builder::actionPlanTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanTitle").build()).build();

    private static final SdkField<String> ACTION_PLAN_INSTRUCTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionPlanInstructions").getter(getter(UpdateControlRequest::actionPlanInstructions))
            .setter(setter(Builder::actionPlanInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanInstructions").build())
            .build();

    private static final SdkField<List<ControlMappingSource>> CONTROL_MAPPING_SOURCES_FIELD = SdkField
            .<List<ControlMappingSource>> builder(MarshallingType.LIST)
            .memberName("controlMappingSources")
            .getter(getter(UpdateControlRequest::controlMappingSources))
            .setter(setter(Builder::controlMappingSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMappingSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlMappingSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlMappingSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TESTING_INFORMATION_FIELD, ACTION_PLAN_TITLE_FIELD, ACTION_PLAN_INSTRUCTIONS_FIELD,
            CONTROL_MAPPING_SOURCES_FIELD));

    private final String controlId;

    private final String name;

    private final String description;

    private final String testingInformation;

    private final String actionPlanTitle;

    private final String actionPlanInstructions;

    private final List<ControlMappingSource> controlMappingSources;

    private UpdateControlRequest(BuilderImpl builder) {
        super(builder);
        this.controlId = builder.controlId;
        this.name = builder.name;
        this.description = builder.description;
        this.testingInformation = builder.testingInformation;
        this.actionPlanTitle = builder.actionPlanTitle;
        this.actionPlanInstructions = builder.actionPlanInstructions;
        this.controlMappingSources = builder.controlMappingSources;
    }

    /**
     * <p>
     * The identifier for the control.
     * </p>
     * 
     * @return The identifier for the control.
     */
    public final String controlId() {
        return controlId;
    }

    /**
     * <p>
     * The name of the updated control.
     * </p>
     * 
     * @return The name of the updated control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The optional description of the control.
     * </p>
     * 
     * @return The optional description of the control.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The steps that you should follow to determine if the control is met.
     * </p>
     * 
     * @return The steps that you should follow to determine if the control is met.
     */
    public final String testingInformation() {
        return testingInformation;
    }

    /**
     * <p>
     * The title of the action plan for remediating the control.
     * </p>
     * 
     * @return The title of the action plan for remediating the control.
     */
    public final String actionPlanTitle() {
        return actionPlanTitle;
    }

    /**
     * <p>
     * The recommended actions to carry out if the control isn't fulfilled.
     * </p>
     * 
     * @return The recommended actions to carry out if the control isn't fulfilled.
     */
    public final String actionPlanInstructions() {
        return actionPlanInstructions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlMappingSources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasControlMappingSources() {
        return controlMappingSources != null && !(controlMappingSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data mapping sources for the control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlMappingSources} method.
     * </p>
     * 
     * @return The data mapping sources for the control.
     */
    public final List<ControlMappingSource> controlMappingSources() {
        return controlMappingSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(testingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(actionPlanTitle());
        hashCode = 31 * hashCode + Objects.hashCode(actionPlanInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlMappingSources() ? controlMappingSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateControlRequest)) {
            return false;
        }
        UpdateControlRequest other = (UpdateControlRequest) obj;
        return Objects.equals(controlId(), other.controlId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(testingInformation(), other.testingInformation())
                && Objects.equals(actionPlanTitle(), other.actionPlanTitle())
                && Objects.equals(actionPlanInstructions(), other.actionPlanInstructions())
                && hasControlMappingSources() == other.hasControlMappingSources()
                && Objects.equals(controlMappingSources(), other.controlMappingSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateControlRequest").add("ControlId", controlId()).add("Name", name())
                .add("Description", description()).add("TestingInformation", testingInformation())
                .add("ActionPlanTitle", actionPlanTitle()).add("ActionPlanInstructions", actionPlanInstructions())
                .add("ControlMappingSources", hasControlMappingSources() ? controlMappingSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlId":
            return Optional.ofNullable(clazz.cast(controlId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "testingInformation":
            return Optional.ofNullable(clazz.cast(testingInformation()));
        case "actionPlanTitle":
            return Optional.ofNullable(clazz.cast(actionPlanTitle()));
        case "actionPlanInstructions":
            return Optional.ofNullable(clazz.cast(actionPlanInstructions()));
        case "controlMappingSources":
            return Optional.ofNullable(clazz.cast(controlMappingSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateControlRequest, T> g) {
        return obj -> g.apply((UpdateControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateControlRequest> {
        /**
         * <p>
         * The identifier for the control.
         * </p>
         * 
         * @param controlId
         *        The identifier for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlId(String controlId);

        /**
         * <p>
         * The name of the updated control.
         * </p>
         * 
         * @param name
         *        The name of the updated control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The optional description of the control.
         * </p>
         * 
         * @param description
         *        The optional description of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The steps that you should follow to determine if the control is met.
         * </p>
         * 
         * @param testingInformation
         *        The steps that you should follow to determine if the control is met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testingInformation(String testingInformation);

        /**
         * <p>
         * The title of the action plan for remediating the control.
         * </p>
         * 
         * @param actionPlanTitle
         *        The title of the action plan for remediating the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPlanTitle(String actionPlanTitle);

        /**
         * <p>
         * The recommended actions to carry out if the control isn't fulfilled.
         * </p>
         * 
         * @param actionPlanInstructions
         *        The recommended actions to carry out if the control isn't fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPlanInstructions(String actionPlanInstructions);

        /**
         * <p>
         * The data mapping sources for the control.
         * </p>
         * 
         * @param controlMappingSources
         *        The data mapping sources for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMappingSources(Collection<ControlMappingSource> controlMappingSources);

        /**
         * <p>
         * The data mapping sources for the control.
         * </p>
         * 
         * @param controlMappingSources
         *        The data mapping sources for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMappingSources(ControlMappingSource... controlMappingSources);

        /**
         * <p>
         * The data mapping sources for the control.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ControlMappingSource>.Builder} avoiding the
         * need to create one manually via {@link List<ControlMappingSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ControlMappingSource>.Builder#build()} is called immediately
         * and its result is passed to {@link #controlMappingSources(List<ControlMappingSource>)}.
         * 
         * @param controlMappingSources
         *        a consumer that will call methods on {@link List<ControlMappingSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlMappingSources(List<ControlMappingSource>)
         */
        Builder controlMappingSources(Consumer<ControlMappingSource.Builder>... controlMappingSources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String controlId;

        private String name;

        private String description;

        private String testingInformation;

        private String actionPlanTitle;

        private String actionPlanInstructions;

        private List<ControlMappingSource> controlMappingSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateControlRequest model) {
            super(model);
            controlId(model.controlId);
            name(model.name);
            description(model.description);
            testingInformation(model.testingInformation);
            actionPlanTitle(model.actionPlanTitle);
            actionPlanInstructions(model.actionPlanInstructions);
            controlMappingSources(model.controlMappingSources);
        }

        public final String getControlId() {
            return controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        @Transient
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTestingInformation() {
            return testingInformation;
        }

        public final void setTestingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
        }

        @Override
        @Transient
        public final Builder testingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
            return this;
        }

        public final String getActionPlanTitle() {
            return actionPlanTitle;
        }

        public final void setActionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
        }

        @Override
        @Transient
        public final Builder actionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
            return this;
        }

        public final String getActionPlanInstructions() {
            return actionPlanInstructions;
        }

        public final void setActionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
        }

        @Override
        @Transient
        public final Builder actionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
            return this;
        }

        public final List<ControlMappingSource.Builder> getControlMappingSources() {
            List<ControlMappingSource.Builder> result = ControlMappingSourcesCopier.copyToBuilder(this.controlMappingSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlMappingSources(Collection<ControlMappingSource.BuilderImpl> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copyFromBuilder(controlMappingSources);
        }

        @Override
        @Transient
        public final Builder controlMappingSources(Collection<ControlMappingSource> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copy(controlMappingSources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlMappingSources(ControlMappingSource... controlMappingSources) {
            controlMappingSources(Arrays.asList(controlMappingSources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controlMappingSources(Consumer<ControlMappingSource.Builder>... controlMappingSources) {
            controlMappingSources(Stream.of(controlMappingSources)
                    .map(c -> ControlMappingSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateControlRequest build() {
            return new UpdateControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
