/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The completion date, current state, submission time, and state change reason (if applicable) for the query execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryExecutionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryExecutionStatus.Builder, QueryExecutionStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryExecutionStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_CHANGE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryExecutionStatus::stateChangeReason)).setter(setter(Builder::stateChangeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final SdkField<Instant> SUBMISSION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(QueryExecutionStatus::submissionDateTime)).setter(setter(Builder::submissionDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionDateTime").build())
            .build();

    private static final SdkField<Instant> COMPLETION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(QueryExecutionStatus::completionDateTime)).setter(setter(Builder::completionDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD, SUBMISSION_DATE_TIME_FIELD, COMPLETION_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String stateChangeReason;

    private final Instant submissionDateTime;

    private final Instant completionDateTime;

    private QueryExecutionStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.submissionDateTime = builder.submissionDateTime;
        this.completionDateTime = builder.completionDateTime;
    }

    /**
     * <p>
     * The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is reserved for
     * future use. <code>RUNNING</code> indicates that the query has been submitted to the service, and Athena will
     * execute the query as soon as resources are available. <code>SUCCEEDED</code> indicates that the query completed
     * without errors. <code>FAILED</code> indicates that the query experienced an error and did not complete
     * processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link QueryExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is
     *         reserved for future use. <code>RUNNING</code> indicates that the query has been submitted to the service,
     *         and Athena will execute the query as soon as resources are available. <code>SUCCEEDED</code> indicates
     *         that the query completed without errors. <code>FAILED</code> indicates that the query experienced an
     *         error and did not complete processing. <code>CANCELLED</code> indicates that a user input interrupted
     *         query execution.
     * @see QueryExecutionState
     */
    public QueryExecutionState state() {
        return QueryExecutionState.fromValue(state);
    }

    /**
     * <p>
     * The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is reserved for
     * future use. <code>RUNNING</code> indicates that the query has been submitted to the service, and Athena will
     * execute the query as soon as resources are available. <code>SUCCEEDED</code> indicates that the query completed
     * without errors. <code>FAILED</code> indicates that the query experienced an error and did not complete
     * processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link QueryExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is
     *         reserved for future use. <code>RUNNING</code> indicates that the query has been submitted to the service,
     *         and Athena will execute the query as soon as resources are available. <code>SUCCEEDED</code> indicates
     *         that the query completed without errors. <code>FAILED</code> indicates that the query experienced an
     *         error and did not complete processing. <code>CANCELLED</code> indicates that a user input interrupted
     *         query execution.
     * @see QueryExecutionState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Further detail about the status of the query.
     * </p>
     * 
     * @return Further detail about the status of the query.
     */
    public String stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * The date and time that the query was submitted.
     * </p>
     * 
     * @return The date and time that the query was submitted.
     */
    public Instant submissionDateTime() {
        return submissionDateTime;
    }

    /**
     * <p>
     * The date and time that the query completed.
     * </p>
     * 
     * @return The date and time that the query completed.
     */
    public Instant completionDateTime() {
        return completionDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(submissionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatus)) {
            return false;
        }
        QueryExecutionStatus other = (QueryExecutionStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason())
                && Objects.equals(submissionDateTime(), other.submissionDateTime())
                && Objects.equals(completionDateTime(), other.completionDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryExecutionStatus").add("State", stateAsString())
                .add("StateChangeReason", stateChangeReason()).add("SubmissionDateTime", submissionDateTime())
                .add("CompletionDateTime", completionDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        case "SubmissionDateTime":
            return Optional.ofNullable(clazz.cast(submissionDateTime()));
        case "CompletionDateTime":
            return Optional.ofNullable(clazz.cast(completionDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatus, T> g) {
        return obj -> g.apply((QueryExecutionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryExecutionStatus> {
        /**
         * <p>
         * The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is reserved
         * for future use. <code>RUNNING</code> indicates that the query has been submitted to the service, and Athena
         * will execute the query as soon as resources are available. <code>SUCCEEDED</code> indicates that the query
         * completed without errors. <code>FAILED</code> indicates that the query experienced an error and did not
         * complete processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.
         * </p>
         * 
         * @param state
         *        The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is
         *        reserved for future use. <code>RUNNING</code> indicates that the query has been submitted to the
         *        service, and Athena will execute the query as soon as resources are available. <code>SUCCEEDED</code>
         *        indicates that the query completed without errors. <code>FAILED</code> indicates that the query
         *        experienced an error and did not complete processing. <code>CANCELLED</code> indicates that a user
         *        input interrupted query execution.
         * @see QueryExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryExecutionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is reserved
         * for future use. <code>RUNNING</code> indicates that the query has been submitted to the service, and Athena
         * will execute the query as soon as resources are available. <code>SUCCEEDED</code> indicates that the query
         * completed without errors. <code>FAILED</code> indicates that the query experienced an error and did not
         * complete processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.
         * </p>
         * 
         * @param state
         *        The state of query execution. <code>QUEUED</code> state is listed but is not used by Athena and is
         *        reserved for future use. <code>RUNNING</code> indicates that the query has been submitted to the
         *        service, and Athena will execute the query as soon as resources are available. <code>SUCCEEDED</code>
         *        indicates that the query completed without errors. <code>FAILED</code> indicates that the query
         *        experienced an error and did not complete processing. <code>CANCELLED</code> indicates that a user
         *        input interrupted query execution.
         * @see QueryExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryExecutionState
         */
        Builder state(QueryExecutionState state);

        /**
         * <p>
         * Further detail about the status of the query.
         * </p>
         * 
         * @param stateChangeReason
         *        Further detail about the status of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(String stateChangeReason);

        /**
         * <p>
         * The date and time that the query was submitted.
         * </p>
         * 
         * @param submissionDateTime
         *        The date and time that the query was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submissionDateTime(Instant submissionDateTime);

        /**
         * <p>
         * The date and time that the query completed.
         * </p>
         * 
         * @param completionDateTime
         *        The date and time that the query completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDateTime(Instant completionDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String stateChangeReason;

        private Instant submissionDateTime;

        private Instant completionDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            submissionDateTime(model.submissionDateTime);
            completionDateTime(model.completionDateTime);
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateChangeReason() {
            return stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public final Instant getSubmissionDateTime() {
            return submissionDateTime;
        }

        @Override
        public final Builder submissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
            return this;
        }

        public final void setSubmissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
        }

        public final Instant getCompletionDateTime() {
            return completionDateTime;
        }

        @Override
        public final Builder completionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
            return this;
        }

        public final void setCompletionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
        }

        @Override
        public QueryExecutionStatus build() {
            return new QueryExecutionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
