/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkGroupsResponse extends AthenaResponse implements
        ToCopyableBuilder<ListWorkGroupsResponse.Builder, ListWorkGroupsResponse> {
    private static final SdkField<List<WorkGroupSummary>> WORK_GROUPS_FIELD = SdkField
            .<List<WorkGroupSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListWorkGroupsResponse::workGroups))
            .setter(setter(Builder::workGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWorkGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<WorkGroupSummary> workGroups;

    private final String nextToken;

    private ListWorkGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.workGroups = builder.workGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of workgroups, including their names, descriptions, creation times, and states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of workgroups, including their names, descriptions, creation times, and states.
     */
    public List<WorkGroupSummary> workGroups() {
        return workGroups;
    }

    /**
     * <p>
     * A token to be used by the next request if this request is truncated.
     * </p>
     * 
     * @return A token to be used by the next request if this request is truncated.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workGroups());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkGroupsResponse)) {
            return false;
        }
        ListWorkGroupsResponse other = (ListWorkGroupsResponse) obj;
        return Objects.equals(workGroups(), other.workGroups()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWorkGroupsResponse").add("WorkGroups", workGroups()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroups":
            return Optional.ofNullable(clazz.cast(workGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkGroupsResponse, T> g) {
        return obj -> g.apply((ListWorkGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkGroupsResponse> {
        /**
         * <p>
         * The list of workgroups, including their names, descriptions, creation times, and states.
         * </p>
         * 
         * @param workGroups
         *        The list of workgroups, including their names, descriptions, creation times, and states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroups(Collection<WorkGroupSummary> workGroups);

        /**
         * <p>
         * The list of workgroups, including their names, descriptions, creation times, and states.
         * </p>
         * 
         * @param workGroups
         *        The list of workgroups, including their names, descriptions, creation times, and states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroups(WorkGroupSummary... workGroups);

        /**
         * <p>
         * The list of workgroups, including their names, descriptions, creation times, and states.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkGroupSummary>.Builder} avoiding the
         * need to create one manually via {@link List<WorkGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkGroupSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #workGroups(List<WorkGroupSummary>)}.
         * 
         * @param workGroups
         *        a consumer that will call methods on {@link List<WorkGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workGroups(List<WorkGroupSummary>)
         */
        Builder workGroups(Consumer<WorkGroupSummary.Builder>... workGroups);

        /**
         * <p>
         * A token to be used by the next request if this request is truncated.
         * </p>
         * 
         * @param nextToken
         *        A token to be used by the next request if this request is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<WorkGroupSummary> workGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkGroupsResponse model) {
            super(model);
            workGroups(model.workGroups);
            nextToken(model.nextToken);
        }

        public final Collection<WorkGroupSummary.Builder> getWorkGroups() {
            return workGroups != null ? workGroups.stream().map(WorkGroupSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workGroups(Collection<WorkGroupSummary> workGroups) {
            this.workGroups = WorkGroupsListCopier.copy(workGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workGroups(WorkGroupSummary... workGroups) {
            workGroups(Arrays.asList(workGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workGroups(Consumer<WorkGroupSummary.Builder>... workGroups) {
            workGroups(Stream.of(workGroups).map(c -> WorkGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWorkGroups(Collection<WorkGroupSummary.BuilderImpl> workGroups) {
            this.workGroups = WorkGroupsListCopier.copyFromBuilder(workGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWorkGroupsResponse build() {
            return new ListWorkGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
