/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionEndpointResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, GetSessionEndpointResponse> {
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointUrl").getter(GetSessionEndpointResponse.getter(GetSessionEndpointResponse::endpointUrl)).setter(GetSessionEndpointResponse.setter(Builder::endpointUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthToken").getter(GetSessionEndpointResponse.getter(GetSessionEndpointResponse::authToken)).setter(GetSessionEndpointResponse.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final SdkField<Instant> AUTH_TOKEN_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AuthTokenExpirationTime").getter(GetSessionEndpointResponse.getter(GetSessionEndpointResponse::authTokenExpirationTime)).setter(GetSessionEndpointResponse.setter(Builder::authTokenExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenExpirationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_URL_FIELD, AUTH_TOKEN_FIELD, AUTH_TOKEN_EXPIRATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionEndpointResponse.memberNameToFieldInitializer();
    private final String endpointUrl;
    private final String authToken;
    private final Instant authTokenExpirationTime;

    private GetSessionEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointUrl = builder.endpointUrl;
        this.authToken = builder.authToken;
        this.authTokenExpirationTime = builder.authTokenExpirationTime;
    }

    public final String endpointUrl() {
        return this.endpointUrl;
    }

    public final String authToken() {
        return this.authToken;
    }

    public final Instant authTokenExpirationTime() {
        return this.authTokenExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionEndpointResponse)) {
            return false;
        }
        GetSessionEndpointResponse other = (GetSessionEndpointResponse)((Object)obj);
        return Objects.equals(this.endpointUrl(), other.endpointUrl()) && Objects.equals(this.authToken(), other.authToken()) && Objects.equals(this.authTokenExpirationTime(), other.authTokenExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionEndpointResponse").add("EndpointUrl", (Object)this.endpointUrl()).add("AuthToken", (Object)this.authToken()).add("AuthTokenExpirationTime", (Object)this.authTokenExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointUrl": {
                return Optional.ofNullable(clazz.cast(this.endpointUrl()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
            case "AuthTokenExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.authTokenExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointUrl", ENDPOINT_URL_FIELD);
        map.put("AuthToken", AUTH_TOKEN_FIELD);
        map.put("AuthTokenExpirationTime", AUTH_TOKEN_EXPIRATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionEndpointResponse, T> g) {
        return obj -> g.apply((GetSessionEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String endpointUrl;
        private String authToken;
        private Instant authTokenExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionEndpointResponse model) {
            super(model);
            this.endpointUrl(model.endpointUrl);
            this.authToken(model.authToken);
            this.authTokenExpirationTime(model.authTokenExpirationTime);
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final Instant getAuthTokenExpirationTime() {
            return this.authTokenExpirationTime;
        }

        public final void setAuthTokenExpirationTime(Instant authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
        }

        @Override
        public final Builder authTokenExpirationTime(Instant authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
            return this;
        }

        @Override
        public GetSessionEndpointResponse build() {
            return new GetSessionEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionEndpointResponse> {
        public Builder endpointUrl(String var1);

        public Builder authToken(String var1);

        public Builder authTokenExpirationTime(Instant var1);
    }
}

