/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.EngineVersion;
import software.amazon.awssdk.services.athena.model.ExecutionParametersCopier;
import software.amazon.awssdk.services.athena.model.ManagedQueryResultsConfiguration;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatistics;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatus;
import software.amazon.awssdk.services.athena.model.QueryResultsS3AccessGrantsConfiguration;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.services.athena.model.ResultReuseConfiguration;
import software.amazon.awssdk.services.athena.model.StatementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryExecution> {
    private static final SdkField<String> QUERY_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryExecutionId").getter(QueryExecution.getter(QueryExecution::queryExecutionId)).setter(QueryExecution.setter(Builder::queryExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionId").build()}).build();
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Query").getter(QueryExecution.getter(QueryExecution::query)).setter(QueryExecution.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()}).build();
    private static final SdkField<String> STATEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementType").getter(QueryExecution.getter(QueryExecution::statementTypeAsString)).setter(QueryExecution.setter(Builder::statementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementType").build()}).build();
    private static final SdkField<ManagedQueryResultsConfiguration> MANAGED_QUERY_RESULTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedQueryResultsConfiguration").getter(QueryExecution.getter(QueryExecution::managedQueryResultsConfiguration)).setter(QueryExecution.setter(Builder::managedQueryResultsConfiguration)).constructor(ManagedQueryResultsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedQueryResultsConfiguration").build()}).build();
    private static final SdkField<ResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultConfiguration").getter(QueryExecution.getter(QueryExecution::resultConfiguration)).setter(QueryExecution.setter(Builder::resultConfiguration)).constructor(ResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfiguration").build()}).build();
    private static final SdkField<ResultReuseConfiguration> RESULT_REUSE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultReuseConfiguration").getter(QueryExecution.getter(QueryExecution::resultReuseConfiguration)).setter(QueryExecution.setter(Builder::resultReuseConfiguration)).constructor(ResultReuseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultReuseConfiguration").build()}).build();
    private static final SdkField<QueryExecutionContext> QUERY_EXECUTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryExecutionContext").getter(QueryExecution.getter(QueryExecution::queryExecutionContext)).setter(QueryExecution.setter(Builder::queryExecutionContext)).constructor(QueryExecutionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionContext").build()}).build();
    private static final SdkField<QueryExecutionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(QueryExecution.getter(QueryExecution::status)).setter(QueryExecution.setter(Builder::status)).constructor(QueryExecutionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<QueryExecutionStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(QueryExecution.getter(QueryExecution::statistics)).setter(QueryExecution.setter(Builder::statistics)).constructor(QueryExecutionStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(QueryExecution.getter(QueryExecution::workGroup)).setter(QueryExecution.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineVersion").getter(QueryExecution.getter(QueryExecution::engineVersion)).setter(QueryExecution.setter(Builder::engineVersion)).constructor(EngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<List<String>> EXECUTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExecutionParameters").getter(QueryExecution.getter(QueryExecution::executionParameters)).setter(QueryExecution.setter(Builder::executionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSTATEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubstatementType").getter(QueryExecution.getter(QueryExecution::substatementType)).setter(QueryExecution.setter(Builder::substatementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubstatementType").build()}).build();
    private static final SdkField<QueryResultsS3AccessGrantsConfiguration> QUERY_RESULTS_S3_ACCESS_GRANTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryResultsS3AccessGrantsConfiguration").getter(QueryExecution.getter(QueryExecution::queryResultsS3AccessGrantsConfiguration)).setter(QueryExecution.setter(Builder::queryResultsS3AccessGrantsConfiguration)).constructor(QueryResultsS3AccessGrantsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultsS3AccessGrantsConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTION_ID_FIELD, QUERY_FIELD, STATEMENT_TYPE_FIELD, MANAGED_QUERY_RESULTS_CONFIGURATION_FIELD, RESULT_CONFIGURATION_FIELD, RESULT_REUSE_CONFIGURATION_FIELD, QUERY_EXECUTION_CONTEXT_FIELD, STATUS_FIELD, STATISTICS_FIELD, WORK_GROUP_FIELD, ENGINE_VERSION_FIELD, EXECUTION_PARAMETERS_FIELD, SUBSTATEMENT_TYPE_FIELD, QUERY_RESULTS_S3_ACCESS_GRANTS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryExecutionId;
    private final String query;
    private final String statementType;
    private final ManagedQueryResultsConfiguration managedQueryResultsConfiguration;
    private final ResultConfiguration resultConfiguration;
    private final ResultReuseConfiguration resultReuseConfiguration;
    private final QueryExecutionContext queryExecutionContext;
    private final QueryExecutionStatus status;
    private final QueryExecutionStatistics statistics;
    private final String workGroup;
    private final EngineVersion engineVersion;
    private final List<String> executionParameters;
    private final String substatementType;
    private final QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration;

    private QueryExecution(BuilderImpl builder) {
        this.queryExecutionId = builder.queryExecutionId;
        this.query = builder.query;
        this.statementType = builder.statementType;
        this.managedQueryResultsConfiguration = builder.managedQueryResultsConfiguration;
        this.resultConfiguration = builder.resultConfiguration;
        this.resultReuseConfiguration = builder.resultReuseConfiguration;
        this.queryExecutionContext = builder.queryExecutionContext;
        this.status = builder.status;
        this.statistics = builder.statistics;
        this.workGroup = builder.workGroup;
        this.engineVersion = builder.engineVersion;
        this.executionParameters = builder.executionParameters;
        this.substatementType = builder.substatementType;
        this.queryResultsS3AccessGrantsConfiguration = builder.queryResultsS3AccessGrantsConfiguration;
    }

    public final String queryExecutionId() {
        return this.queryExecutionId;
    }

    public final String query() {
        return this.query;
    }

    public final StatementType statementType() {
        return StatementType.fromValue(this.statementType);
    }

    public final String statementTypeAsString() {
        return this.statementType;
    }

    public final ManagedQueryResultsConfiguration managedQueryResultsConfiguration() {
        return this.managedQueryResultsConfiguration;
    }

    public final ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public final ResultReuseConfiguration resultReuseConfiguration() {
        return this.resultReuseConfiguration;
    }

    public final QueryExecutionContext queryExecutionContext() {
        return this.queryExecutionContext;
    }

    public final QueryExecutionStatus status() {
        return this.status;
    }

    public final QueryExecutionStatistics statistics() {
        return this.statistics;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public final EngineVersion engineVersion() {
        return this.engineVersion;
    }

    public final boolean hasExecutionParameters() {
        return this.executionParameters != null && !(this.executionParameters instanceof SdkAutoConstructList);
    }

    public final List<String> executionParameters() {
        return this.executionParameters;
    }

    public final String substatementType() {
        return this.substatementType;
    }

    public final QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration() {
        return this.queryResultsS3AccessGrantsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedQueryResultsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultReuseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionParameters() ? this.executionParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.substatementType());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryResultsS3AccessGrantsConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecution)) {
            return false;
        }
        QueryExecution other = (QueryExecution)obj;
        return Objects.equals(this.queryExecutionId(), other.queryExecutionId()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.statementTypeAsString(), other.statementTypeAsString()) && Objects.equals(this.managedQueryResultsConfiguration(), other.managedQueryResultsConfiguration()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.resultReuseConfiguration(), other.resultReuseConfiguration()) && Objects.equals(this.queryExecutionContext(), other.queryExecutionContext()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.engineVersion(), other.engineVersion()) && this.hasExecutionParameters() == other.hasExecutionParameters() && Objects.equals(this.executionParameters(), other.executionParameters()) && Objects.equals(this.substatementType(), other.substatementType()) && Objects.equals(this.queryResultsS3AccessGrantsConfiguration(), other.queryResultsS3AccessGrantsConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"QueryExecution").add("QueryExecutionId", (Object)this.queryExecutionId()).add("Query", (Object)this.query()).add("StatementType", (Object)this.statementTypeAsString()).add("ManagedQueryResultsConfiguration", (Object)this.managedQueryResultsConfiguration()).add("ResultConfiguration", (Object)this.resultConfiguration()).add("ResultReuseConfiguration", (Object)this.resultReuseConfiguration()).add("QueryExecutionContext", (Object)this.queryExecutionContext()).add("Status", (Object)this.status()).add("Statistics", (Object)this.statistics()).add("WorkGroup", (Object)this.workGroup()).add("EngineVersion", (Object)this.engineVersion()).add("ExecutionParameters", this.hasExecutionParameters() ? this.executionParameters() : null).add("SubstatementType", (Object)this.substatementType()).add("QueryResultsS3AccessGrantsConfiguration", (Object)this.queryResultsS3AccessGrantsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionId": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionId()));
            }
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "StatementType": {
                return Optional.ofNullable(clazz.cast(this.statementTypeAsString()));
            }
            case "ManagedQueryResultsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.managedQueryResultsConfiguration()));
            }
            case "ResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "ResultReuseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultReuseConfiguration()));
            }
            case "QueryExecutionContext": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionContext()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ExecutionParameters": {
                return Optional.ofNullable(clazz.cast(this.executionParameters()));
            }
            case "SubstatementType": {
                return Optional.ofNullable(clazz.cast(this.substatementType()));
            }
            case "QueryResultsS3AccessGrantsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.queryResultsS3AccessGrantsConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryExecutionId", QUERY_EXECUTION_ID_FIELD);
        map.put("Query", QUERY_FIELD);
        map.put("StatementType", STATEMENT_TYPE_FIELD);
        map.put("ManagedQueryResultsConfiguration", MANAGED_QUERY_RESULTS_CONFIGURATION_FIELD);
        map.put("ResultConfiguration", RESULT_CONFIGURATION_FIELD);
        map.put("ResultReuseConfiguration", RESULT_REUSE_CONFIGURATION_FIELD);
        map.put("QueryExecutionContext", QUERY_EXECUTION_CONTEXT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("ExecutionParameters", EXECUTION_PARAMETERS_FIELD);
        map.put("SubstatementType", SUBSTATEMENT_TYPE_FIELD);
        map.put("QueryResultsS3AccessGrantsConfiguration", QUERY_RESULTS_S3_ACCESS_GRANTS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryExecution, T> g) {
        return obj -> g.apply((QueryExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryExecutionId;
        private String query;
        private String statementType;
        private ManagedQueryResultsConfiguration managedQueryResultsConfiguration;
        private ResultConfiguration resultConfiguration;
        private ResultReuseConfiguration resultReuseConfiguration;
        private QueryExecutionContext queryExecutionContext;
        private QueryExecutionStatus status;
        private QueryExecutionStatistics statistics;
        private String workGroup;
        private EngineVersion engineVersion;
        private List<String> executionParameters = DefaultSdkAutoConstructList.getInstance();
        private String substatementType;
        private QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecution model) {
            this.queryExecutionId(model.queryExecutionId);
            this.query(model.query);
            this.statementType(model.statementType);
            this.managedQueryResultsConfiguration(model.managedQueryResultsConfiguration);
            this.resultConfiguration(model.resultConfiguration);
            this.resultReuseConfiguration(model.resultReuseConfiguration);
            this.queryExecutionContext(model.queryExecutionContext);
            this.status(model.status);
            this.statistics(model.statistics);
            this.workGroup(model.workGroup);
            this.engineVersion(model.engineVersion);
            this.executionParameters(model.executionParameters);
            this.substatementType(model.substatementType);
            this.queryResultsS3AccessGrantsConfiguration(model.queryResultsS3AccessGrantsConfiguration);
        }

        public final String getQueryExecutionId() {
            return this.queryExecutionId;
        }

        public final void setQueryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
        }

        @Override
        public final Builder queryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
            return this;
        }

        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getStatementType() {
            return this.statementType;
        }

        public final void setStatementType(String statementType) {
            this.statementType = statementType;
        }

        @Override
        public final Builder statementType(String statementType) {
            this.statementType = statementType;
            return this;
        }

        @Override
        public final Builder statementType(StatementType statementType) {
            this.statementType(statementType == null ? null : statementType.toString());
            return this;
        }

        public final ManagedQueryResultsConfiguration.Builder getManagedQueryResultsConfiguration() {
            return this.managedQueryResultsConfiguration != null ? this.managedQueryResultsConfiguration.toBuilder() : null;
        }

        public final void setManagedQueryResultsConfiguration(ManagedQueryResultsConfiguration.BuilderImpl managedQueryResultsConfiguration) {
            this.managedQueryResultsConfiguration = managedQueryResultsConfiguration != null ? managedQueryResultsConfiguration.build() : null;
        }

        @Override
        public final Builder managedQueryResultsConfiguration(ManagedQueryResultsConfiguration managedQueryResultsConfiguration) {
            this.managedQueryResultsConfiguration = managedQueryResultsConfiguration;
            return this;
        }

        public final ResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ResultReuseConfiguration.Builder getResultReuseConfiguration() {
            return this.resultReuseConfiguration != null ? this.resultReuseConfiguration.toBuilder() : null;
        }

        public final void setResultReuseConfiguration(ResultReuseConfiguration.BuilderImpl resultReuseConfiguration) {
            this.resultReuseConfiguration = resultReuseConfiguration != null ? resultReuseConfiguration.build() : null;
        }

        @Override
        public final Builder resultReuseConfiguration(ResultReuseConfiguration resultReuseConfiguration) {
            this.resultReuseConfiguration = resultReuseConfiguration;
            return this;
        }

        public final QueryExecutionContext.Builder getQueryExecutionContext() {
            return this.queryExecutionContext != null ? this.queryExecutionContext.toBuilder() : null;
        }

        public final void setQueryExecutionContext(QueryExecutionContext.BuilderImpl queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext != null ? queryExecutionContext.build() : null;
        }

        @Override
        public final Builder queryExecutionContext(QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
            return this;
        }

        public final QueryExecutionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(QueryExecutionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(QueryExecutionStatus status) {
            this.status = status;
            return this;
        }

        public final QueryExecutionStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(QueryExecutionStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(QueryExecutionStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return this.engineVersion != null ? this.engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Collection<String> getExecutionParameters() {
            if (this.executionParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionParameters;
        }

        public final void setExecutionParameters(Collection<String> executionParameters) {
            this.executionParameters = ExecutionParametersCopier.copy(executionParameters);
        }

        @Override
        public final Builder executionParameters(Collection<String> executionParameters) {
            this.executionParameters = ExecutionParametersCopier.copy(executionParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionParameters(String ... executionParameters) {
            this.executionParameters(Arrays.asList(executionParameters));
            return this;
        }

        public final String getSubstatementType() {
            return this.substatementType;
        }

        public final void setSubstatementType(String substatementType) {
            this.substatementType = substatementType;
        }

        @Override
        public final Builder substatementType(String substatementType) {
            this.substatementType = substatementType;
            return this;
        }

        public final QueryResultsS3AccessGrantsConfiguration.Builder getQueryResultsS3AccessGrantsConfiguration() {
            return this.queryResultsS3AccessGrantsConfiguration != null ? this.queryResultsS3AccessGrantsConfiguration.toBuilder() : null;
        }

        public final void setQueryResultsS3AccessGrantsConfiguration(QueryResultsS3AccessGrantsConfiguration.BuilderImpl queryResultsS3AccessGrantsConfiguration) {
            this.queryResultsS3AccessGrantsConfiguration = queryResultsS3AccessGrantsConfiguration != null ? queryResultsS3AccessGrantsConfiguration.build() : null;
        }

        @Override
        public final Builder queryResultsS3AccessGrantsConfiguration(QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration) {
            this.queryResultsS3AccessGrantsConfiguration = queryResultsS3AccessGrantsConfiguration;
            return this;
        }

        public QueryExecution build() {
            return new QueryExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryExecution> {
        public Builder queryExecutionId(String var1);

        public Builder query(String var1);

        public Builder statementType(String var1);

        public Builder statementType(StatementType var1);

        public Builder managedQueryResultsConfiguration(ManagedQueryResultsConfiguration var1);

        default public Builder managedQueryResultsConfiguration(Consumer<ManagedQueryResultsConfiguration.Builder> managedQueryResultsConfiguration) {
            return this.managedQueryResultsConfiguration((ManagedQueryResultsConfiguration)((ManagedQueryResultsConfiguration.Builder)ManagedQueryResultsConfiguration.builder().applyMutation(managedQueryResultsConfiguration)).build());
        }

        public Builder resultConfiguration(ResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ResultConfiguration)((ResultConfiguration.Builder)ResultConfiguration.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder resultReuseConfiguration(ResultReuseConfiguration var1);

        default public Builder resultReuseConfiguration(Consumer<ResultReuseConfiguration.Builder> resultReuseConfiguration) {
            return this.resultReuseConfiguration((ResultReuseConfiguration)((ResultReuseConfiguration.Builder)ResultReuseConfiguration.builder().applyMutation(resultReuseConfiguration)).build());
        }

        public Builder queryExecutionContext(QueryExecutionContext var1);

        default public Builder queryExecutionContext(Consumer<QueryExecutionContext.Builder> queryExecutionContext) {
            return this.queryExecutionContext((QueryExecutionContext)((QueryExecutionContext.Builder)QueryExecutionContext.builder().applyMutation(queryExecutionContext)).build());
        }

        public Builder status(QueryExecutionStatus var1);

        default public Builder status(Consumer<QueryExecutionStatus.Builder> status) {
            return this.status((QueryExecutionStatus)((QueryExecutionStatus.Builder)QueryExecutionStatus.builder().applyMutation(status)).build());
        }

        public Builder statistics(QueryExecutionStatistics var1);

        default public Builder statistics(Consumer<QueryExecutionStatistics.Builder> statistics) {
            return this.statistics((QueryExecutionStatistics)((QueryExecutionStatistics.Builder)QueryExecutionStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder workGroup(String var1);

        public Builder engineVersion(EngineVersion var1);

        default public Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return this.engineVersion((EngineVersion)((EngineVersion.Builder)EngineVersion.builder().applyMutation(engineVersion)).build());
        }

        public Builder executionParameters(Collection<String> var1);

        public Builder executionParameters(String ... var1);

        public Builder substatementType(String var1);

        public Builder queryResultsS3AccessGrantsConfiguration(QueryResultsS3AccessGrantsConfiguration var1);

        default public Builder queryResultsS3AccessGrantsConfiguration(Consumer<QueryResultsS3AccessGrantsConfiguration.Builder> queryResultsS3AccessGrantsConfiguration) {
            return this.queryResultsS3AccessGrantsConfiguration((QueryResultsS3AccessGrantsConfiguration)((QueryResultsS3AccessGrantsConfiguration.Builder)QueryResultsS3AccessGrantsConfiguration.builder().applyMutation(queryResultsS3AccessGrantsConfiguration)).build());
        }
    }
}

