/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.EngineVersion;
import software.amazon.awssdk.services.athena.model.WorkGroupState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkGroupSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WorkGroupSummary.getter(WorkGroupSummary::name)).setter(WorkGroupSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(WorkGroupSummary.getter(WorkGroupSummary::stateAsString)).setter(WorkGroupSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(WorkGroupSummary.getter(WorkGroupSummary::description)).setter(WorkGroupSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(WorkGroupSummary.getter(WorkGroupSummary::creationTime)).setter(WorkGroupSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineVersion").getter(WorkGroupSummary.getter(WorkGroupSummary::engineVersion)).setter(WorkGroupSummary.setter(Builder::engineVersion)).constructor(EngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityCenterApplicationArn").getter(WorkGroupSummary.getter(WorkGroupSummary::identityCenterApplicationArn)).setter(WorkGroupSummary.setter(Builder::identityCenterApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, ENGINE_VERSION_FIELD, IDENTITY_CENTER_APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkGroupSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String state;
    private final String description;
    private final Instant creationTime;
    private final EngineVersion engineVersion;
    private final String identityCenterApplicationArn;

    private WorkGroupSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.engineVersion = builder.engineVersion;
        this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
    }

    public final String name() {
        return this.name;
    }

    public final WorkGroupState state() {
        return WorkGroupState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final EngineVersion engineVersion() {
        return this.engineVersion;
    }

    public final String identityCenterApplicationArn() {
        return this.identityCenterApplicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterApplicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroupSummary)) {
            return false;
        }
        WorkGroupSummary other = (WorkGroupSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.identityCenterApplicationArn(), other.identityCenterApplicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"WorkGroupSummary").add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("EngineVersion", (Object)this.engineVersion()).add("IdentityCenterApplicationArn", (Object)this.identityCenterApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "IdentityCenterApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.identityCenterApplicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("IdentityCenterApplicationArn", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkGroupSummary, T> g) {
        return obj -> g.apply((WorkGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String state;
        private String description;
        private Instant creationTime;
        private EngineVersion engineVersion;
        private String identityCenterApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroupSummary model) {
            this.name(model.name);
            this.state(model.state);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.engineVersion(model.engineVersion);
            this.identityCenterApplicationArn(model.identityCenterApplicationArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return this.engineVersion != null ? this.engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getIdentityCenterApplicationArn() {
            return this.identityCenterApplicationArn;
        }

        public final void setIdentityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
        }

        @Override
        public final Builder identityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
            return this;
        }

        public WorkGroupSummary build() {
            return new WorkGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkGroupSummary> {
        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(WorkGroupState var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder engineVersion(EngineVersion var1);

        default public Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return this.engineVersion((EngineVersion)((EngineVersion.Builder)EngineVersion.builder().applyMutation(engineVersion)).build());
        }

        public Builder identityCenterApplicationArn(String var1);
    }
}

