/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the status of a session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionStatus implements SdkPojo, Serializable, ToCopyableBuilder<SessionStatus.Builder, SessionStatus> {
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDateTime").getter(getter(SessionStatus::startDateTime)).setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDateTime").getter(getter(SessionStatus::lastModifiedDateTime))
            .setter(setter(Builder::lastModifiedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDateTime").build())
            .build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDateTime").getter(getter(SessionStatus::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();

    private static final SdkField<Instant> IDLE_SINCE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IdleSinceDateTime").getter(getter(SessionStatus::idleSinceDateTime))
            .setter(setter(Builder::idleSinceDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleSinceDateTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(SessionStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_CHANGE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateChangeReason").getter(getter(SessionStatus::stateChangeReason))
            .setter(setter(Builder::stateChangeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_TIME_FIELD,
            LAST_MODIFIED_DATE_TIME_FIELD, END_DATE_TIME_FIELD, IDLE_SINCE_DATE_TIME_FIELD, STATE_FIELD,
            STATE_CHANGE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startDateTime;

    private final Instant lastModifiedDateTime;

    private final Instant endDateTime;

    private final Instant idleSinceDateTime;

    private final String state;

    private final String stateChangeReason;

    private SessionStatus(BuilderImpl builder) {
        this.startDateTime = builder.startDateTime;
        this.lastModifiedDateTime = builder.lastModifiedDateTime;
        this.endDateTime = builder.endDateTime;
        this.idleSinceDateTime = builder.idleSinceDateTime;
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    /**
     * <p>
     * The date and time that the session started.
     * </p>
     * 
     * @return The date and time that the session started.
     */
    public final Instant startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * The most recent date and time that the session was modified.
     * </p>
     * 
     * @return The most recent date and time that the session was modified.
     */
    public final Instant lastModifiedDateTime() {
        return lastModifiedDateTime;
    }

    /**
     * <p>
     * The date and time that the session ended.
     * </p>
     * 
     * @return The date and time that the session ended.
     */
    public final Instant endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * The date and time starting at which the session became idle. Can be empty if the session is not currently idle.
     * </p>
     * 
     * @return The date and time starting at which the session became idle. Can be empty if the session is not currently
     *         idle.
     */
    public final Instant idleSinceDateTime() {
        return idleSinceDateTime;
    }

    /**
     * <p>
     * The state of the session. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the session. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The session is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The session has been started.
     *         </p>
     *         <p>
     *         <code>IDLE</code> - The session is able to accept a calculation.
     *         </p>
     *         <p>
     *         <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The session is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The session and its resources are no longer running.
     *         </p>
     *         <p>
     *         <code>DEGRADED</code> - The session has no healthy coordinators.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @see SessionState
     */
    public final SessionState state() {
        return SessionState.fromValue(state);
    }

    /**
     * <p>
     * The state of the session. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the session. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The session is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The session has been started.
     *         </p>
     *         <p>
     *         <code>IDLE</code> - The session is able to accept a calculation.
     *         </p>
     *         <p>
     *         <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The session is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The session and its resources are no longer running.
     *         </p>
     *         <p>
     *         <code>DEGRADED</code> - The session has no healthy coordinators.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @see SessionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the session state change (for example, canceled because the session was terminated).
     * </p>
     * 
     * @return The reason for the session state change (for example, canceled because the session was terminated).
     */
    public final String stateChangeReason() {
        return stateChangeReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(idleSinceDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionStatus)) {
            return false;
        }
        SessionStatus other = (SessionStatus) obj;
        return Objects.equals(startDateTime(), other.startDateTime())
                && Objects.equals(lastModifiedDateTime(), other.lastModifiedDateTime())
                && Objects.equals(endDateTime(), other.endDateTime())
                && Objects.equals(idleSinceDateTime(), other.idleSinceDateTime())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionStatus").add("StartDateTime", startDateTime())
                .add("LastModifiedDateTime", lastModifiedDateTime()).add("EndDateTime", endDateTime())
                .add("IdleSinceDateTime", idleSinceDateTime()).add("State", stateAsString())
                .add("StateChangeReason", stateChangeReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "LastModifiedDateTime":
            return Optional.ofNullable(clazz.cast(lastModifiedDateTime()));
        case "EndDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "IdleSinceDateTime":
            return Optional.ofNullable(clazz.cast(idleSinceDateTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionStatus, T> g) {
        return obj -> g.apply((SessionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionStatus> {
        /**
         * <p>
         * The date and time that the session started.
         * </p>
         * 
         * @param startDateTime
         *        The date and time that the session started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(Instant startDateTime);

        /**
         * <p>
         * The most recent date and time that the session was modified.
         * </p>
         * 
         * @param lastModifiedDateTime
         *        The most recent date and time that the session was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDateTime(Instant lastModifiedDateTime);

        /**
         * <p>
         * The date and time that the session ended.
         * </p>
         * 
         * @param endDateTime
         *        The date and time that the session ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);

        /**
         * <p>
         * The date and time starting at which the session became idle. Can be empty if the session is not currently
         * idle.
         * </p>
         * 
         * @param idleSinceDateTime
         *        The date and time starting at which the session became idle. Can be empty if the session is not
         *        currently idle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSinceDateTime(Instant idleSinceDateTime);

        /**
         * <p>
         * The state of the session. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The session is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The session has been started.
         * </p>
         * <p>
         * <code>IDLE</code> - The session is able to accept a calculation.
         * </p>
         * <p>
         * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The session is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The session and its resources are no longer running.
         * </p>
         * <p>
         * <code>DEGRADED</code> - The session has no healthy coordinators.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * </p>
         * 
         * @param state
         *        The state of the session. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The session is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The session has been started.
         *        </p>
         *        <p>
         *        <code>IDLE</code> - The session is able to accept a calculation.
         *        </p>
         *        <p>
         *        <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The session is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The session and its resources are no longer running.
         *        </p>
         *        <p>
         *        <code>DEGRADED</code> - The session has no healthy coordinators.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the session. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The session is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The session has been started.
         * </p>
         * <p>
         * <code>IDLE</code> - The session is able to accept a calculation.
         * </p>
         * <p>
         * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The session is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The session and its resources are no longer running.
         * </p>
         * <p>
         * <code>DEGRADED</code> - The session has no healthy coordinators.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * </p>
         * 
         * @param state
         *        The state of the session. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The session is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The session has been started.
         *        </p>
         *        <p>
         *        <code>IDLE</code> - The session is able to accept a calculation.
         *        </p>
         *        <p>
         *        <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The session is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The session and its resources are no longer running.
         *        </p>
         *        <p>
         *        <code>DEGRADED</code> - The session has no healthy coordinators.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(SessionState state);

        /**
         * <p>
         * The reason for the session state change (for example, canceled because the session was terminated).
         * </p>
         * 
         * @param stateChangeReason
         *        The reason for the session state change (for example, canceled because the session was terminated).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(String stateChangeReason);
    }

    static final class BuilderImpl implements Builder {
        private Instant startDateTime;

        private Instant lastModifiedDateTime;

        private Instant endDateTime;

        private Instant idleSinceDateTime;

        private String state;

        private String stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionStatus model) {
            startDateTime(model.startDateTime);
            lastModifiedDateTime(model.lastModifiedDateTime);
            endDateTime(model.endDateTime);
            idleSinceDateTime(model.idleSinceDateTime);
            state(model.state);
            stateChangeReason(model.stateChangeReason);
        }

        public final Instant getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getLastModifiedDateTime() {
            return lastModifiedDateTime;
        }

        public final void setLastModifiedDateTime(Instant lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }

        @Override
        public final Builder lastModifiedDateTime(Instant lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final Instant getIdleSinceDateTime() {
            return idleSinceDateTime;
        }

        public final void setIdleSinceDateTime(Instant idleSinceDateTime) {
            this.idleSinceDateTime = idleSinceDateTime;
        }

        @Override
        public final Builder idleSinceDateTime(Instant idleSinceDateTime) {
            this.idleSinceDateTime = idleSinceDateTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateChangeReason() {
            return stateChangeReason;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        @Override
        public SessionStatus build() {
            return new SessionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
