/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutorType {
    COORDINATOR("COORDINATOR"),
    GATEWAY("GATEWAY"),
    WORKER("WORKER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutorType> VALUE_MAP;
    private final String value;

    private ExecutorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutorType> knownValues() {
        EnumSet<ExecutorType> knownValues = EnumSet.allOf(ExecutorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutorType.class, ExecutorType::toString);
    }
}

