/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultSetMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultSetMetadata> {
    private static final SdkField<List<ColumnInfo>> COLUMN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnInfo").getter(ResultSetMetadata.getter(ResultSetMetadata::columnInfo)).setter(ResultSetMetadata.setter(Builder::columnInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ColumnInfo> columnInfo;

    private ResultSetMetadata(BuilderImpl builder) {
        this.columnInfo = builder.columnInfo;
    }

    public final boolean hasColumnInfo() {
        return this.columnInfo != null && !(this.columnInfo instanceof SdkAutoConstructList);
    }

    public final List<ColumnInfo> columnInfo() {
        return this.columnInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnInfo() ? this.columnInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetMetadata)) {
            return false;
        }
        ResultSetMetadata other = (ResultSetMetadata)obj;
        return this.hasColumnInfo() == other.hasColumnInfo() && Objects.equals(this.columnInfo(), other.columnInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ResultSetMetadata").add("ColumnInfo", this.hasColumnInfo() ? this.columnInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnInfo": {
                return Optional.ofNullable(clazz.cast(this.columnInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultSetMetadata, T> g) {
        return obj -> g.apply((ResultSetMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ColumnInfo> columnInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetMetadata model) {
            this.columnInfo(model.columnInfo);
        }

        public final List<ColumnInfo.Builder> getColumnInfo() {
            List<ColumnInfo.Builder> result = ColumnInfoListCopier.copyToBuilder(this.columnInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder columnInfo(Collection<ColumnInfo> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copy(columnInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(ColumnInfo ... columnInfo) {
            this.columnInfo(Arrays.asList(columnInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(Consumer<ColumnInfo.Builder> ... columnInfo) {
            this.columnInfo(Stream.of(columnInfo).map(c -> (ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnInfo(Collection<ColumnInfo.BuilderImpl> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copyFromBuilder(columnInfo);
        }

        public ResultSetMetadata build() {
            return new ResultSetMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultSetMetadata> {
        public Builder columnInfo(Collection<ColumnInfo> var1);

        public Builder columnInfo(ColumnInfo ... var1);

        public Builder columnInfo(Consumer<ColumnInfo.Builder> ... var1);
    }
}

