/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.artifact.model.ArtifactResponse;
import software.amazon.awssdk.services.artifact.model.CustomerAgreementListCopier;
import software.amazon.awssdk.services.artifact.model.CustomerAgreementSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomerAgreementsResponse
extends ArtifactResponse
implements ToCopyableBuilder<Builder, ListCustomerAgreementsResponse> {
    private static final SdkField<List<CustomerAgreementSummary>> CUSTOMER_AGREEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customerAgreements").getter(ListCustomerAgreementsResponse.getter(ListCustomerAgreementsResponse::customerAgreements)).setter(ListCustomerAgreementsResponse.setter(Builder::customerAgreements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAgreements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomerAgreementSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCustomerAgreementsResponse.getter(ListCustomerAgreementsResponse::nextToken)).setter(ListCustomerAgreementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_AGREEMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCustomerAgreementsResponse.memberNameToFieldInitializer();
    private final List<CustomerAgreementSummary> customerAgreements;
    private final String nextToken;

    private ListCustomerAgreementsResponse(BuilderImpl builder) {
        super(builder);
        this.customerAgreements = builder.customerAgreements;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCustomerAgreements() {
        return this.customerAgreements != null && !(this.customerAgreements instanceof SdkAutoConstructList);
    }

    public final List<CustomerAgreementSummary> customerAgreements() {
        return this.customerAgreements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerAgreements() ? this.customerAgreements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomerAgreementsResponse)) {
            return false;
        }
        ListCustomerAgreementsResponse other = (ListCustomerAgreementsResponse)((Object)obj);
        return this.hasCustomerAgreements() == other.hasCustomerAgreements() && Objects.equals(this.customerAgreements(), other.customerAgreements()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomerAgreementsResponse").add("CustomerAgreements", this.hasCustomerAgreements() ? this.customerAgreements() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerAgreements": {
                return Optional.ofNullable(clazz.cast(this.customerAgreements()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerAgreements", CUSTOMER_AGREEMENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomerAgreementsResponse, T> g) {
        return obj -> g.apply((ListCustomerAgreementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArtifactResponse.BuilderImpl
    implements Builder {
        private List<CustomerAgreementSummary> customerAgreements = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomerAgreementsResponse model) {
            super(model);
            this.customerAgreements(model.customerAgreements);
            this.nextToken(model.nextToken);
        }

        public final List<CustomerAgreementSummary.Builder> getCustomerAgreements() {
            List<CustomerAgreementSummary.Builder> result = CustomerAgreementListCopier.copyToBuilder(this.customerAgreements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomerAgreements(Collection<CustomerAgreementSummary.BuilderImpl> customerAgreements) {
            this.customerAgreements = CustomerAgreementListCopier.copyFromBuilder(customerAgreements);
        }

        @Override
        public final Builder customerAgreements(Collection<CustomerAgreementSummary> customerAgreements) {
            this.customerAgreements = CustomerAgreementListCopier.copy(customerAgreements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerAgreements(CustomerAgreementSummary ... customerAgreements) {
            this.customerAgreements(Arrays.asList(customerAgreements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerAgreements(Consumer<CustomerAgreementSummary.Builder> ... customerAgreements) {
            this.customerAgreements(Stream.of(customerAgreements).map(c -> (CustomerAgreementSummary)((CustomerAgreementSummary.Builder)CustomerAgreementSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomerAgreementsResponse build() {
            return new ListCustomerAgreementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArtifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomerAgreementsResponse> {
        public Builder customerAgreements(Collection<CustomerAgreementSummary> var1);

        public Builder customerAgreements(CustomerAgreementSummary ... var1);

        public Builder customerAgreements(Consumer<CustomerAgreementSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

