/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.artifact.ArtifactAsyncClient;
import software.amazon.awssdk.services.artifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.artifact.model.ListReportVersionsRequest;
import software.amazon.awssdk.services.artifact.model.ListReportVersionsResponse;
import software.amazon.awssdk.services.artifact.model.ReportSummary;

public class ListReportVersionsPublisher
implements SdkPublisher<ListReportVersionsResponse> {
    private final ArtifactAsyncClient client;
    private final ListReportVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReportVersionsPublisher(ArtifactAsyncClient client, ListReportVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReportVersionsPublisher(ArtifactAsyncClient client, ListReportVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReportVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReportVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReportSummary> reports() {
        Function<ListReportVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reports() != null) {
                return response.reports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReportVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReportVersionsResponseFetcher
    implements AsyncPageFetcher<ListReportVersionsResponse> {
        private ListReportVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReportVersionsResponse> nextPage(ListReportVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListReportVersionsPublisher.this.client.listReportVersions(ListReportVersionsPublisher.this.firstRequest);
            }
            return ListReportVersionsPublisher.this.client.listReportVersions((ListReportVersionsRequest)((Object)ListReportVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

