/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arczonalshift.model.AppliedWeightsCopier;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftInResource;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftsInResourceCopier;
import software.amazon.awssdk.services.arczonalshift.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.arczonalshift.model.ZonalAutoshiftStatus;
import software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource;
import software.amazon.awssdk.services.arczonalshift.model.ZonalShiftsInResourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedResourceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedResourceSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ManagedResourceSummary.getter(ManagedResourceSummary::arn)).setter(ManagedResourceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ManagedResourceSummary.getter(ManagedResourceSummary::name)).setter(ManagedResourceSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availabilityZones").getter(ManagedResourceSummary.getter(ManagedResourceSummary::availabilityZones)).setter(ManagedResourceSummary.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Float>> APPLIED_WEIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("appliedWeights").getter(ManagedResourceSummary.getter(ManagedResourceSummary::appliedWeights)).setter(ManagedResourceSummary.setter(Builder::appliedWeights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedWeights").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.FLOAT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ZonalShiftInResource>> ZONAL_SHIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("zonalShifts").getter(ManagedResourceSummary.getter(ManagedResourceSummary::zonalShifts)).setter(ManagedResourceSummary.setter(Builder::zonalShifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ZonalShiftInResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutoshiftInResource>> AUTOSHIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoshifts").getter(ManagedResourceSummary.getter(ManagedResourceSummary::autoshifts)).setter(ManagedResourceSummary.setter(Builder::autoshifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoshifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoshiftInResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ZONAL_AUTOSHIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zonalAutoshiftStatus").getter(ManagedResourceSummary.getter(ManagedResourceSummary::zonalAutoshiftStatusAsString)).setter(ManagedResourceSummary.setter(Builder::zonalAutoshiftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalAutoshiftStatus").build()}).build();
    private static final SdkField<String> PRACTICE_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("practiceRunStatus").getter(ManagedResourceSummary.getter(ManagedResourceSummary::practiceRunStatusAsString)).setter(ManagedResourceSummary.setter(Builder::practiceRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("practiceRunStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, AVAILABILITY_ZONES_FIELD, APPLIED_WEIGHTS_FIELD, ZONAL_SHIFTS_FIELD, AUTOSHIFTS_FIELD, ZONAL_AUTOSHIFT_STATUS_FIELD, PRACTICE_RUN_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedResourceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final List<String> availabilityZones;
    private final Map<String, Float> appliedWeights;
    private final List<ZonalShiftInResource> zonalShifts;
    private final List<AutoshiftInResource> autoshifts;
    private final String zonalAutoshiftStatus;
    private final String practiceRunStatus;

    private ManagedResourceSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.availabilityZones = builder.availabilityZones;
        this.appliedWeights = builder.appliedWeights;
        this.zonalShifts = builder.zonalShifts;
        this.autoshifts = builder.autoshifts;
        this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
        this.practiceRunStatus = builder.practiceRunStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasAppliedWeights() {
        return this.appliedWeights != null && !(this.appliedWeights instanceof SdkAutoConstructMap);
    }

    public final Map<String, Float> appliedWeights() {
        return this.appliedWeights;
    }

    public final boolean hasZonalShifts() {
        return this.zonalShifts != null && !(this.zonalShifts instanceof SdkAutoConstructList);
    }

    public final List<ZonalShiftInResource> zonalShifts() {
        return this.zonalShifts;
    }

    public final boolean hasAutoshifts() {
        return this.autoshifts != null && !(this.autoshifts instanceof SdkAutoConstructList);
    }

    public final List<AutoshiftInResource> autoshifts() {
        return this.autoshifts;
    }

    public final ZonalAutoshiftStatus zonalAutoshiftStatus() {
        return ZonalAutoshiftStatus.fromValue(this.zonalAutoshiftStatus);
    }

    public final String zonalAutoshiftStatusAsString() {
        return this.zonalAutoshiftStatus;
    }

    public final ZonalAutoshiftStatus practiceRunStatus() {
        return ZonalAutoshiftStatus.fromValue(this.practiceRunStatus);
    }

    public final String practiceRunStatusAsString() {
        return this.practiceRunStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppliedWeights() ? this.appliedWeights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasZonalShifts() ? this.zonalShifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoshifts() ? this.autoshifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalAutoshiftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.practiceRunStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedResourceSummary)) {
            return false;
        }
        ManagedResourceSummary other = (ManagedResourceSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasAppliedWeights() == other.hasAppliedWeights() && Objects.equals(this.appliedWeights(), other.appliedWeights()) && this.hasZonalShifts() == other.hasZonalShifts() && Objects.equals(this.zonalShifts(), other.zonalShifts()) && this.hasAutoshifts() == other.hasAutoshifts() && Objects.equals(this.autoshifts(), other.autoshifts()) && Objects.equals(this.zonalAutoshiftStatusAsString(), other.zonalAutoshiftStatusAsString()) && Objects.equals(this.practiceRunStatusAsString(), other.practiceRunStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedResourceSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("AppliedWeights", this.hasAppliedWeights() ? this.appliedWeights() : null).add("ZonalShifts", this.hasZonalShifts() ? this.zonalShifts() : null).add("Autoshifts", this.hasAutoshifts() ? this.autoshifts() : null).add("ZonalAutoshiftStatus", (Object)this.zonalAutoshiftStatusAsString()).add("PracticeRunStatus", (Object)this.practiceRunStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "availabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "appliedWeights": {
                return Optional.ofNullable(clazz.cast(this.appliedWeights()));
            }
            case "zonalShifts": {
                return Optional.ofNullable(clazz.cast(this.zonalShifts()));
            }
            case "autoshifts": {
                return Optional.ofNullable(clazz.cast(this.autoshifts()));
            }
            case "zonalAutoshiftStatus": {
                return Optional.ofNullable(clazz.cast(this.zonalAutoshiftStatusAsString()));
            }
            case "practiceRunStatus": {
                return Optional.ofNullable(clazz.cast(this.practiceRunStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("availabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("appliedWeights", APPLIED_WEIGHTS_FIELD);
        map.put("zonalShifts", ZONAL_SHIFTS_FIELD);
        map.put("autoshifts", AUTOSHIFTS_FIELD);
        map.put("zonalAutoshiftStatus", ZONAL_AUTOSHIFT_STATUS_FIELD);
        map.put("practiceRunStatus", PRACTICE_RUN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedResourceSummary, T> g) {
        return obj -> g.apply((ManagedResourceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Float> appliedWeights = DefaultSdkAutoConstructMap.getInstance();
        private List<ZonalShiftInResource> zonalShifts = DefaultSdkAutoConstructList.getInstance();
        private List<AutoshiftInResource> autoshifts = DefaultSdkAutoConstructList.getInstance();
        private String zonalAutoshiftStatus;
        private String practiceRunStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedResourceSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.availabilityZones(model.availabilityZones);
            this.appliedWeights(model.appliedWeights);
            this.zonalShifts(model.zonalShifts);
            this.autoshifts(model.autoshifts);
            this.zonalAutoshiftStatus(model.zonalAutoshiftStatus);
            this.practiceRunStatus(model.practiceRunStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Map<String, Float> getAppliedWeights() {
            if (this.appliedWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.appliedWeights;
        }

        public final void setAppliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
        }

        @Override
        public final Builder appliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
            return this;
        }

        public final List<ZonalShiftInResource.Builder> getZonalShifts() {
            List<ZonalShiftInResource.Builder> result = ZonalShiftsInResourceCopier.copyToBuilder(this.zonalShifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZonalShifts(Collection<ZonalShiftInResource.BuilderImpl> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copyFromBuilder(zonalShifts);
        }

        @Override
        public final Builder zonalShifts(Collection<ZonalShiftInResource> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copy(zonalShifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(ZonalShiftInResource ... zonalShifts) {
            this.zonalShifts(Arrays.asList(zonalShifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(Consumer<ZonalShiftInResource.Builder> ... zonalShifts) {
            this.zonalShifts(Stream.of(zonalShifts).map(c -> (ZonalShiftInResource)((ZonalShiftInResource.Builder)ZonalShiftInResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutoshiftInResource.Builder> getAutoshifts() {
            List<AutoshiftInResource.Builder> result = AutoshiftsInResourceCopier.copyToBuilder(this.autoshifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoshifts(Collection<AutoshiftInResource.BuilderImpl> autoshifts) {
            this.autoshifts = AutoshiftsInResourceCopier.copyFromBuilder(autoshifts);
        }

        @Override
        public final Builder autoshifts(Collection<AutoshiftInResource> autoshifts) {
            this.autoshifts = AutoshiftsInResourceCopier.copy(autoshifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoshifts(AutoshiftInResource ... autoshifts) {
            this.autoshifts(Arrays.asList(autoshifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoshifts(Consumer<AutoshiftInResource.Builder> ... autoshifts) {
            this.autoshifts(Stream.of(autoshifts).map(c -> (AutoshiftInResource)((AutoshiftInResource.Builder)AutoshiftInResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getZonalAutoshiftStatus() {
            return this.zonalAutoshiftStatus;
        }

        public final void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
        }

        @Override
        public final Builder zonalAutoshiftStatus(String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        @Override
        public final Builder zonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus(zonalAutoshiftStatus == null ? null : zonalAutoshiftStatus.toString());
            return this;
        }

        public final String getPracticeRunStatus() {
            return this.practiceRunStatus;
        }

        public final void setPracticeRunStatus(String practiceRunStatus) {
            this.practiceRunStatus = practiceRunStatus;
        }

        @Override
        public final Builder practiceRunStatus(String practiceRunStatus) {
            this.practiceRunStatus = practiceRunStatus;
            return this;
        }

        @Override
        public final Builder practiceRunStatus(ZonalAutoshiftStatus practiceRunStatus) {
            this.practiceRunStatus(practiceRunStatus == null ? null : practiceRunStatus.toString());
            return this;
        }

        public ManagedResourceSummary build() {
            return new ManagedResourceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedResourceSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder appliedWeights(Map<String, Float> var1);

        public Builder zonalShifts(Collection<ZonalShiftInResource> var1);

        public Builder zonalShifts(ZonalShiftInResource ... var1);

        public Builder zonalShifts(Consumer<ZonalShiftInResource.Builder> ... var1);

        public Builder autoshifts(Collection<AutoshiftInResource> var1);

        public Builder autoshifts(AutoshiftInResource ... var1);

        public Builder autoshifts(Consumer<AutoshiftInResource.Builder> ... var1);

        public Builder zonalAutoshiftStatus(String var1);

        public Builder zonalAutoshiftStatus(ZonalAutoshiftStatus var1);

        public Builder practiceRunStatus(String var1);

        public Builder practiceRunStatus(ZonalAutoshiftStatus var1);
    }
}

