/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesScalingResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesScalingResource> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(KubernetesScalingResource.getter(KubernetesScalingResource::namespace)).setter(KubernetesScalingResource.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(KubernetesScalingResource.getter(KubernetesScalingResource::name)).setter(KubernetesScalingResource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> HPA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hpaName").getter(KubernetesScalingResource.getter(KubernetesScalingResource::hpaName)).setter(KubernetesScalingResource.setter(Builder::hpaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpaName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, NAME_FIELD, HPA_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KubernetesScalingResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String name;
    private final String hpaName;

    private KubernetesScalingResource(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.hpaName = builder.hpaName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String name() {
        return this.name;
    }

    public final String hpaName() {
        return this.hpaName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hpaName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesScalingResource)) {
            return false;
        }
        KubernetesScalingResource other = (KubernetesScalingResource)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.hpaName(), other.hpaName());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesScalingResource").add("Namespace", (Object)this.namespace()).add("Name", (Object)this.name()).add("HpaName", (Object)this.hpaName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "hpaName": {
                return Optional.ofNullable(clazz.cast(this.hpaName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("hpaName", HPA_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesScalingResource, T> g) {
        return obj -> g.apply((KubernetesScalingResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String name;
        private String hpaName;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesScalingResource model) {
            this.namespace(model.namespace);
            this.name(model.name);
            this.hpaName(model.hpaName);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getHpaName() {
            return this.hpaName;
        }

        public final void setHpaName(String hpaName) {
            this.hpaName = hpaName;
        }

        @Override
        public final Builder hpaName(String hpaName) {
            this.hpaName = hpaName;
            return this;
        }

        public KubernetesScalingResource build() {
            return new KubernetesScalingResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesScalingResource> {
        public Builder namespace(String var1);

        public Builder name(String var1);

        public Builder hpaName(String var1);
    }
}

