/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionEvent;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsResponse;

public class ListPlanExecutionEventsPublisher
implements SdkPublisher<ListPlanExecutionEventsResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final ListPlanExecutionEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlanExecutionEventsPublisher(ArcRegionSwitchAsyncClient client, ListPlanExecutionEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlanExecutionEventsPublisher(ArcRegionSwitchAsyncClient client, ListPlanExecutionEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlanExecutionEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlanExecutionEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExecutionEvent> items() {
        Function<ListPlanExecutionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlanExecutionEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlanExecutionEventsResponseFetcher
    implements AsyncPageFetcher<ListPlanExecutionEventsResponse> {
        private ListPlanExecutionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlanExecutionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlanExecutionEventsResponse> nextPage(ListPlanExecutionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListPlanExecutionEventsPublisher.this.client.listPlanExecutionEvents(ListPlanExecutionEventsPublisher.this.firstRequest);
            }
            return ListPlanExecutionEventsPublisher.this.client.listPlanExecutionEvents((ListPlanExecutionEventsRequest)((Object)ListPlanExecutionEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

