/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionAction;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPlanExecutionRequest
extends ArcRegionSwitchRequest
implements ToCopyableBuilder<Builder, StartPlanExecutionRequest> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planArn").getter(StartPlanExecutionRequest.getter(StartPlanExecutionRequest::planArn)).setter(StartPlanExecutionRequest.setter(Builder::planArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()}).build();
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetRegion").getter(StartPlanExecutionRequest.getter(StartPlanExecutionRequest::targetRegion)).setter(StartPlanExecutionRequest.setter(Builder::targetRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(StartPlanExecutionRequest.getter(StartPlanExecutionRequest::actionAsString)).setter(StartPlanExecutionRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(StartPlanExecutionRequest.getter(StartPlanExecutionRequest::modeAsString)).setter(StartPlanExecutionRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(StartPlanExecutionRequest.getter(StartPlanExecutionRequest::comment)).setter(StartPlanExecutionRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestVersion").getter(StartPlanExecutionRequest.getter(StartPlanExecutionRequest::latestVersion)).setter(StartPlanExecutionRequest.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD, TARGET_REGION_FIELD, ACTION_FIELD, MODE_FIELD, COMMENT_FIELD, LATEST_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartPlanExecutionRequest.memberNameToFieldInitializer();
    private final String planArn;
    private final String targetRegion;
    private final String action;
    private final String mode;
    private final String comment;
    private final String latestVersion;

    private StartPlanExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.targetRegion = builder.targetRegion;
        this.action = builder.action;
        this.mode = builder.mode;
        this.comment = builder.comment;
        this.latestVersion = builder.latestVersion;
    }

    public final String planArn() {
        return this.planArn;
    }

    public final String targetRegion() {
        return this.targetRegion;
    }

    public final ExecutionAction action() {
        return ExecutionAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String comment() {
        return this.comment;
    }

    public final String latestVersion() {
        return this.latestVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.planArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPlanExecutionRequest)) {
            return false;
        }
        StartPlanExecutionRequest other = (StartPlanExecutionRequest)((Object)obj);
        return Objects.equals(this.planArn(), other.planArn()) && Objects.equals(this.targetRegion(), other.targetRegion()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.latestVersion(), other.latestVersion());
    }

    public final String toString() {
        return ToString.builder((String)"StartPlanExecutionRequest").add("PlanArn", (Object)this.planArn()).add("TargetRegion", (Object)this.targetRegion()).add("Action", (Object)this.actionAsString()).add("Mode", (Object)this.modeAsString()).add("Comment", (Object)this.comment()).add("LatestVersion", (Object)this.latestVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planArn": {
                return Optional.ofNullable(clazz.cast(this.planArn()));
            }
            case "targetRegion": {
                return Optional.ofNullable(clazz.cast(this.targetRegion()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("targetRegion", TARGET_REGION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPlanExecutionRequest, T> g) {
        return obj -> g.apply((StartPlanExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchRequest.BuilderImpl
    implements Builder {
        private String planArn;
        private String targetRegion;
        private String action;
        private String mode;
        private String comment;
        private String latestVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPlanExecutionRequest model) {
            super(model);
            this.planArn(model.planArn);
            this.targetRegion(model.targetRegion);
            this.action(model.action);
            this.mode(model.mode);
            this.comment(model.comment);
            this.latestVersion(model.latestVersion);
        }

        public final String getPlanArn() {
            return this.planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getTargetRegion() {
            return this.targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ExecutionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPlanExecutionRequest build() {
            return new StartPlanExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPlanExecutionRequest> {
        public Builder planArn(String var1);

        public Builder targetRegion(String var1);

        public Builder action(String var1);

        public Builder action(ExecutionAction var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder comment(String var1);

        public Builder latestVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

