/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.CompareDataSetsSummary;
import software.amazon.awssdk.services.apptest.model.CompareDatabaseCDCSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompareFileType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompareFileType> {
    private static final SdkField<CompareDataSetsSummary> DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasets").getter(CompareFileType.getter(CompareFileType::datasets)).setter(CompareFileType.setter(Builder::datasets)).constructor(CompareDataSetsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasets").build()}).build();
    private static final SdkField<CompareDatabaseCDCSummary> DATABASE_CDC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("databaseCDC").getter(CompareFileType.getter(CompareFileType::databaseCDC)).setter(CompareFileType.setter(Builder::databaseCDC)).constructor(CompareDatabaseCDCSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseCDC").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD, DATABASE_CDC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompareFileType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CompareDataSetsSummary datasets;
    private final CompareDatabaseCDCSummary databaseCDC;
    private final Type type;

    private CompareFileType(BuilderImpl builder) {
        this.datasets = builder.datasets;
        this.databaseCDC = builder.databaseCDC;
        this.type = builder.type;
    }

    public final CompareDataSetsSummary datasets() {
        return this.datasets;
    }

    public final CompareDatabaseCDCSummary databaseCDC() {
        return this.databaseCDC;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasets());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseCDC());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFileType)) {
            return false;
        }
        CompareFileType other = (CompareFileType)obj;
        return Objects.equals(this.datasets(), other.datasets()) && Objects.equals(this.databaseCDC(), other.databaseCDC());
    }

    public final String toString() {
        return ToString.builder((String)"CompareFileType").add("Datasets", (Object)this.datasets()).add("DatabaseCDC", (Object)this.databaseCDC()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasets": {
                return Optional.ofNullable(clazz.cast(this.datasets()));
            }
            case "databaseCDC": {
                return Optional.ofNullable(clazz.cast(this.databaseCDC()));
            }
        }
        return Optional.empty();
    }

    public static CompareFileType fromDatasets(CompareDataSetsSummary datasets) {
        return (CompareFileType)CompareFileType.builder().datasets(datasets).build();
    }

    public static CompareFileType fromDatasets(Consumer<CompareDataSetsSummary.Builder> datasets) {
        CompareDataSetsSummary.Builder builder = CompareDataSetsSummary.builder();
        datasets.accept(builder);
        return CompareFileType.fromDatasets((CompareDataSetsSummary)builder.build());
    }

    public static CompareFileType fromDatabaseCDC(CompareDatabaseCDCSummary databaseCDC) {
        return (CompareFileType)CompareFileType.builder().databaseCDC(databaseCDC).build();
    }

    public static CompareFileType fromDatabaseCDC(Consumer<CompareDatabaseCDCSummary.Builder> databaseCDC) {
        CompareDatabaseCDCSummary.Builder builder = CompareDatabaseCDCSummary.builder();
        databaseCDC.accept(builder);
        return CompareFileType.fromDatabaseCDC((CompareDatabaseCDCSummary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasets", DATASETS_FIELD);
        map.put("databaseCDC", DATABASE_CDC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompareFileType, T> g) {
        return obj -> g.apply((CompareFileType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATASETS,
        DATABASE_CDC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CompareDataSetsSummary datasets;
        private CompareDatabaseCDCSummary databaseCDC;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFileType model) {
            this.datasets(model.datasets);
            this.databaseCDC(model.databaseCDC);
        }

        public final CompareDataSetsSummary.Builder getDatasets() {
            return this.datasets != null ? this.datasets.toBuilder() : null;
        }

        public final void setDatasets(CompareDataSetsSummary.BuilderImpl datasets) {
            CompareDataSetsSummary oldValue = this.datasets;
            this.datasets = datasets != null ? datasets.build() : null;
            this.handleUnionValueChange(Type.DATASETS, oldValue, this.datasets);
        }

        @Override
        public final Builder datasets(CompareDataSetsSummary datasets) {
            CompareDataSetsSummary oldValue = this.datasets;
            this.datasets = datasets;
            this.handleUnionValueChange(Type.DATASETS, oldValue, this.datasets);
            return this;
        }

        public final CompareDatabaseCDCSummary.Builder getDatabaseCDC() {
            return this.databaseCDC != null ? this.databaseCDC.toBuilder() : null;
        }

        public final void setDatabaseCDC(CompareDatabaseCDCSummary.BuilderImpl databaseCDC) {
            CompareDatabaseCDCSummary oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC != null ? databaseCDC.build() : null;
            this.handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
        }

        @Override
        public final Builder databaseCDC(CompareDatabaseCDCSummary databaseCDC) {
            CompareDatabaseCDCSummary oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC;
            this.handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
            return this;
        }

        public CompareFileType build() {
            return new CompareFileType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompareFileType> {
        public Builder datasets(CompareDataSetsSummary var1);

        default public Builder datasets(Consumer<CompareDataSetsSummary.Builder> datasets) {
            return this.datasets((CompareDataSetsSummary)((CompareDataSetsSummary.Builder)CompareDataSetsSummary.builder().applyMutation(datasets)).build());
        }

        public Builder databaseCDC(CompareDatabaseCDCSummary var1);

        default public Builder databaseCDC(Consumer<CompareDatabaseCDCSummary.Builder> databaseCDC) {
            return this.databaseCDC((CompareDatabaseCDCSummary)((CompareDatabaseCDCSummary.Builder)CompareDatabaseCDCSummary.builder().applyMutation(databaseCDC)).build());
        }
    }
}

