/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.ExportDataSetNamesCopier;
import software.amazon.awssdk.services.apptest.model.Script;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TN3270
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TN3270> {
    private static final SdkField<Script> SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("script").getter(TN3270.getter(TN3270::script)).setter(TN3270.setter(Builder::script)).constructor(Script::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()}).build();
    private static final SdkField<List<String>> EXPORT_DATA_SET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportDataSetNames").getter(TN3270.getter(TN3270::exportDataSetNames)).setter(TN3270.setter(Builder::exportDataSetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataSetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_FIELD, EXPORT_DATA_SET_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TN3270.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Script script;
    private final List<String> exportDataSetNames;

    private TN3270(BuilderImpl builder) {
        this.script = builder.script;
        this.exportDataSetNames = builder.exportDataSetNames;
    }

    public final Script script() {
        return this.script;
    }

    public final boolean hasExportDataSetNames() {
        return this.exportDataSetNames != null && !(this.exportDataSetNames instanceof SdkAutoConstructList);
    }

    public final List<String> exportDataSetNames() {
        return this.exportDataSetNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.script());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportDataSetNames() ? this.exportDataSetNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TN3270)) {
            return false;
        }
        TN3270 other = (TN3270)obj;
        return Objects.equals(this.script(), other.script()) && this.hasExportDataSetNames() == other.hasExportDataSetNames() && Objects.equals(this.exportDataSetNames(), other.exportDataSetNames());
    }

    public final String toString() {
        return ToString.builder((String)"TN3270").add("Script", (Object)this.script()).add("ExportDataSetNames", this.hasExportDataSetNames() ? this.exportDataSetNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "script": {
                return Optional.ofNullable(clazz.cast(this.script()));
            }
            case "exportDataSetNames": {
                return Optional.ofNullable(clazz.cast(this.exportDataSetNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("script", SCRIPT_FIELD);
        map.put("exportDataSetNames", EXPORT_DATA_SET_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TN3270, T> g) {
        return obj -> g.apply((TN3270)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Script script;
        private List<String> exportDataSetNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TN3270 model) {
            this.script(model.script);
            this.exportDataSetNames(model.exportDataSetNames);
        }

        public final Script.Builder getScript() {
            return this.script != null ? this.script.toBuilder() : null;
        }

        public final void setScript(Script.BuilderImpl script) {
            this.script = script != null ? script.build() : null;
        }

        @Override
        public final Builder script(Script script) {
            this.script = script;
            return this;
        }

        public final Collection<String> getExportDataSetNames() {
            if (this.exportDataSetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportDataSetNames;
        }

        public final void setExportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
        }

        @Override
        public final Builder exportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataSetNames(String ... exportDataSetNames) {
            this.exportDataSetNames(Arrays.asList(exportDataSetNames));
            return this;
        }

        public TN3270 build() {
            return new TN3270(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TN3270> {
        public Builder script(Script var1);

        default public Builder script(Consumer<Script.Builder> script) {
            return this.script((Script)((Script.Builder)Script.builder().applyMutation(script)).build());
        }

        public Builder exportDataSetNames(Collection<String> var1);

        public Builder exportDataSetNames(String ... var1);
    }
}

