/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.InputFile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Input
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Input> {
    private static final SdkField<InputFile> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(Input.getter(Input::file)).setter(Input.setter(Builder::file)).constructor(InputFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Input.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InputFile file;
    private final Type type;

    private Input(BuilderImpl builder) {
        this.file = builder.file;
        this.type = builder.type;
    }

    public final InputFile file() {
        return this.file;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.file(), other.file());
    }

    public final String toString() {
        return ToString.builder((String)"Input").add("File", (Object)this.file()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
        }
        return Optional.empty();
    }

    public static Input fromFile(InputFile file) {
        return (Input)Input.builder().file(file).build();
    }

    public static Input fromFile(Consumer<InputFile.Builder> file) {
        InputFile.Builder builder = InputFile.builder();
        file.accept(builder);
        return Input.fromFile((InputFile)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<InputFile>> map = new HashMap<String, SdkField<InputFile>>();
        map.put("file", FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private InputFile file;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.file(model.file);
        }

        public final InputFile.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(InputFile.BuilderImpl file) {
            InputFile oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(InputFile file) {
            InputFile oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public Input build() {
            return new Input(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Input> {
        public Builder file(InputFile var1);

        default public Builder file(Consumer<InputFile.Builder> file) {
            return this.file((InputFile)((InputFile.Builder)InputFile.builder().applyMutation(file)).build());
        }
    }
}

