/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse;
import software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary;

public class ListSourceApiAssociationsIterable
implements SdkIterable<ListSourceApiAssociationsResponse> {
    private final AppSyncClient client;
    private final ListSourceApiAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourceApiAssociationsIterable(AppSyncClient client, ListSourceApiAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSourceApiAssociationsResponseFetcher();
    }

    public Iterator<ListSourceApiAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SourceApiAssociationSummary> sourceApiAssociationSummaries() {
        Function<ListSourceApiAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceApiAssociationSummaries() != null) {
                return response.sourceApiAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourceApiAssociationsResponseFetcher
    implements SyncPageFetcher<ListSourceApiAssociationsResponse> {
        private ListSourceApiAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceApiAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourceApiAssociationsResponse nextPage(ListSourceApiAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListSourceApiAssociationsIterable.this.client.listSourceApiAssociations(ListSourceApiAssociationsIterable.this.firstRequest);
            }
            return ListSourceApiAssociationsIterable.this.client.listSourceApiAssociations((ListSourceApiAssociationsRequest)((Object)ListSourceApiAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

