/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.GraphqlApi;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;

public class ListGraphqlApisIterable
implements SdkIterable<ListGraphqlApisResponse> {
    private final AppSyncClient client;
    private final ListGraphqlApisRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGraphqlApisIterable(AppSyncClient client, ListGraphqlApisRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGraphqlApisResponseFetcher();
    }

    public Iterator<ListGraphqlApisResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GraphqlApi> graphqlApis() {
        Function<ListGraphqlApisResponse, Iterator> getIterator = response -> {
            if (response != null && response.graphqlApis() != null) {
                return response.graphqlApis().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGraphqlApisResponseFetcher
    implements SyncPageFetcher<ListGraphqlApisResponse> {
        private ListGraphqlApisResponseFetcher() {
        }

        public boolean hasNextPage(ListGraphqlApisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGraphqlApisResponse nextPage(ListGraphqlApisResponse previousPage) {
            if (previousPage == null) {
                return ListGraphqlApisIterable.this.client.listGraphqlApis(ListGraphqlApisIterable.this.firstRequest);
            }
            return ListGraphqlApisIterable.this.client.listGraphqlApis((ListGraphqlApisRequest)((Object)ListGraphqlApisIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

