/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.DataSource;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;

public class ListDataSourcesPublisher
implements SdkPublisher<ListDataSourcesResponse> {
    private final AppSyncAsyncClient client;
    private final ListDataSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSourcesPublisher(AppSyncAsyncClient client, ListDataSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSourcesPublisher(AppSyncAsyncClient client, ListDataSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSource> dataSources() {
        Function<ListDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSources() != null) {
                return response.dataSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSourcesResponseFetcher
    implements AsyncPageFetcher<ListDataSourcesResponse> {
        private ListDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSourcesResponse> nextPage(ListDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourcesPublisher.this.client.listDataSources(ListDataSourcesPublisher.this.firstRequest);
            }
            return ListDataSourcesPublisher.this.client.listDataSources((ListDataSourcesRequest)((Object)ListDataSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

