/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HandlerBehavior {
    CODE("CODE"),
    DIRECT("DIRECT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandlerBehavior> VALUE_MAP;
    private final String value;

    private HandlerBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandlerBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandlerBehavior> knownValues() {
        EnumSet<HandlerBehavior> knownValues = EnumSet.allOf(HandlerBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HandlerBehavior.class, HandlerBehavior::toString);
    }
}

