/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.DeltaSyncConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamodbDataSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamodbDataSourceConfig> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(DynamodbDataSourceConfig.getter(DynamodbDataSourceConfig::tableName)).setter(DynamodbDataSourceConfig.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(DynamodbDataSourceConfig.getter(DynamodbDataSourceConfig::awsRegion)).setter(DynamodbDataSourceConfig.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<Boolean> USE_CALLER_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useCallerCredentials").getter(DynamodbDataSourceConfig.getter(DynamodbDataSourceConfig::useCallerCredentials)).setter(DynamodbDataSourceConfig.setter(Builder::useCallerCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useCallerCredentials").build()}).build();
    private static final SdkField<DeltaSyncConfig> DELTA_SYNC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deltaSyncConfig").getter(DynamodbDataSourceConfig.getter(DynamodbDataSourceConfig::deltaSyncConfig)).setter(DynamodbDataSourceConfig.setter(Builder::deltaSyncConfig)).constructor(DeltaSyncConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deltaSyncConfig").build()}).build();
    private static final SdkField<Boolean> VERSIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("versioned").getter(DynamodbDataSourceConfig.getter(DynamodbDataSourceConfig::versioned)).setter(DynamodbDataSourceConfig.setter(Builder::versioned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, AWS_REGION_FIELD, USE_CALLER_CREDENTIALS_FIELD, DELTA_SYNC_CONFIG_FIELD, VERSIONED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DynamodbDataSourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final String awsRegion;
    private final Boolean useCallerCredentials;
    private final DeltaSyncConfig deltaSyncConfig;
    private final Boolean versioned;

    private DynamodbDataSourceConfig(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.awsRegion = builder.awsRegion;
        this.useCallerCredentials = builder.useCallerCredentials;
        this.deltaSyncConfig = builder.deltaSyncConfig;
        this.versioned = builder.versioned;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final Boolean useCallerCredentials() {
        return this.useCallerCredentials;
    }

    public final DeltaSyncConfig deltaSyncConfig() {
        return this.deltaSyncConfig;
    }

    public final Boolean versioned() {
        return this.versioned;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCallerCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.deltaSyncConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.versioned());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamodbDataSourceConfig)) {
            return false;
        }
        DynamodbDataSourceConfig other = (DynamodbDataSourceConfig)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.useCallerCredentials(), other.useCallerCredentials()) && Objects.equals(this.deltaSyncConfig(), other.deltaSyncConfig()) && Objects.equals(this.versioned(), other.versioned());
    }

    public final String toString() {
        return ToString.builder((String)"DynamodbDataSourceConfig").add("TableName", (Object)this.tableName()).add("AwsRegion", (Object)this.awsRegion()).add("UseCallerCredentials", (Object)this.useCallerCredentials()).add("DeltaSyncConfig", (Object)this.deltaSyncConfig()).add("Versioned", (Object)this.versioned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "useCallerCredentials": {
                return Optional.ofNullable(clazz.cast(this.useCallerCredentials()));
            }
            case "deltaSyncConfig": {
                return Optional.ofNullable(clazz.cast(this.deltaSyncConfig()));
            }
            case "versioned": {
                return Optional.ofNullable(clazz.cast(this.versioned()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("useCallerCredentials", USE_CALLER_CREDENTIALS_FIELD);
        map.put("deltaSyncConfig", DELTA_SYNC_CONFIG_FIELD);
        map.put("versioned", VERSIONED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamodbDataSourceConfig, T> g) {
        return obj -> g.apply((DynamodbDataSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String awsRegion;
        private Boolean useCallerCredentials;
        private DeltaSyncConfig deltaSyncConfig;
        private Boolean versioned;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamodbDataSourceConfig model) {
            this.tableName(model.tableName);
            this.awsRegion(model.awsRegion);
            this.useCallerCredentials(model.useCallerCredentials);
            this.deltaSyncConfig(model.deltaSyncConfig);
            this.versioned(model.versioned);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final Boolean getUseCallerCredentials() {
            return this.useCallerCredentials;
        }

        public final void setUseCallerCredentials(Boolean useCallerCredentials) {
            this.useCallerCredentials = useCallerCredentials;
        }

        @Override
        public final Builder useCallerCredentials(Boolean useCallerCredentials) {
            this.useCallerCredentials = useCallerCredentials;
            return this;
        }

        public final DeltaSyncConfig.Builder getDeltaSyncConfig() {
            return this.deltaSyncConfig != null ? this.deltaSyncConfig.toBuilder() : null;
        }

        public final void setDeltaSyncConfig(DeltaSyncConfig.BuilderImpl deltaSyncConfig) {
            this.deltaSyncConfig = deltaSyncConfig != null ? deltaSyncConfig.build() : null;
        }

        @Override
        public final Builder deltaSyncConfig(DeltaSyncConfig deltaSyncConfig) {
            this.deltaSyncConfig = deltaSyncConfig;
            return this;
        }

        public final Boolean getVersioned() {
            return this.versioned;
        }

        public final void setVersioned(Boolean versioned) {
            this.versioned = versioned;
        }

        @Override
        public final Builder versioned(Boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        public DynamodbDataSourceConfig build() {
            return new DynamodbDataSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamodbDataSourceConfig> {
        public Builder tableName(String var1);

        public Builder awsRegion(String var1);

        public Builder useCallerCredentials(Boolean var1);

        public Builder deltaSyncConfig(DeltaSyncConfig var1);

        default public Builder deltaSyncConfig(Consumer<DeltaSyncConfig.Builder> deltaSyncConfig) {
            return this.deltaSyncConfig((DeltaSyncConfig)((DeltaSyncConfig.Builder)DeltaSyncConfig.builder().applyMutation(deltaSyncConfig)).build());
        }

        public Builder versioned(Boolean var1);
    }
}

