/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.EventConfig;
import software.amazon.awssdk.services.appsync.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateApiRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateApiRequest.getter(CreateApiRequest::name)).setter(CreateApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNER_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerContact").getter(CreateApiRequest.getter(CreateApiRequest::ownerContact)).setter(CreateApiRequest.setter(Builder::ownerContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerContact").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateApiRequest.getter(CreateApiRequest::tags)).setter(CreateApiRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EventConfig> EVENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventConfig").getter(CreateApiRequest.getter(CreateApiRequest::eventConfig)).setter(CreateApiRequest.setter(Builder::eventConfig)).constructor(EventConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OWNER_CONTACT_FIELD, TAGS_FIELD, EVENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApiRequest.memberNameToFieldInitializer();
    private final String name;
    private final String ownerContact;
    private final Map<String, String> tags;
    private final EventConfig eventConfig;

    private CreateApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ownerContact = builder.ownerContact;
        this.tags = builder.tags;
        this.eventConfig = builder.eventConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerContact() {
        return this.ownerContact;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final EventConfig eventConfig() {
        return this.eventConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiRequest)) {
            return false;
        }
        CreateApiRequest other = (CreateApiRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerContact(), other.ownerContact()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.eventConfig(), other.eventConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApiRequest").add("Name", (Object)this.name()).add("OwnerContact", (Object)this.ownerContact()).add("Tags", this.hasTags() ? this.tags() : null).add("EventConfig", (Object)this.eventConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ownerContact": {
                return Optional.ofNullable(clazz.cast(this.ownerContact()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "eventConfig": {
                return Optional.ofNullable(clazz.cast(this.eventConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("ownerContact", OWNER_CONTACT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("eventConfig", EVENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApiRequest, T> g) {
        return obj -> g.apply((CreateApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String name;
        private String ownerContact;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private EventConfig eventConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiRequest model) {
            super(model);
            this.name(model.name);
            this.ownerContact(model.ownerContact);
            this.tags(model.tags);
            this.eventConfig(model.eventConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerContact() {
            return this.ownerContact;
        }

        public final void setOwnerContact(String ownerContact) {
            this.ownerContact = ownerContact;
        }

        @Override
        public final Builder ownerContact(String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final EventConfig.Builder getEventConfig() {
            return this.eventConfig != null ? this.eventConfig.toBuilder() : null;
        }

        public final void setEventConfig(EventConfig.BuilderImpl eventConfig) {
            this.eventConfig = eventConfig != null ? eventConfig.build() : null;
        }

        @Override
        public final Builder eventConfig(EventConfig eventConfig) {
            this.eventConfig = eventConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiRequest build() {
            return new CreateApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiRequest> {
        public Builder name(String var1);

        public Builder ownerContact(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder eventConfig(EventConfig var1);

        default public Builder eventConfig(Consumer<EventConfig.Builder> eventConfig) {
            return this.eventConfig((EventConfig)((EventConfig.Builder)EventConfig.builder().applyMutation(eventConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

