/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.FleetErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(ResourceError.getter(ResourceError::errorCodeAsString)).setter(ResourceError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ResourceError.getter(ResourceError::errorMessage)).setter(ResourceError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> ERROR_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ErrorTimestamp").getter(ResourceError.getter(ResourceError::errorTimestamp)).setter(ResourceError.setter(Builder::errorTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, ERROR_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String errorMessage;
    private final Instant errorTimestamp;

    private ResourceError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.errorTimestamp = builder.errorTimestamp;
    }

    public final FleetErrorCode errorCode() {
        return FleetErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant errorTimestamp() {
        return this.errorTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceError)) {
            return false;
        }
        ResourceError other = (ResourceError)obj;
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorTimestamp(), other.errorTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceError").add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorTimestamp", (Object)this.errorTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ErrorTimestamp": {
                return Optional.ofNullable(clazz.cast(this.errorTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ErrorTimestamp", ERROR_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceError, T> g) {
        return obj -> g.apply((ResourceError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorMessage;
        private Instant errorTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceError model) {
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.errorTimestamp(model.errorTimestamp);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(FleetErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getErrorTimestamp() {
            return this.errorTimestamp;
        }

        public final void setErrorTimestamp(Instant errorTimestamp) {
            this.errorTimestamp = errorTimestamp;
        }

        @Override
        public final Builder errorTimestamp(Instant errorTimestamp) {
            this.errorTimestamp = errorTimestamp;
            return this;
        }

        public ResourceError build() {
            return new ResourceError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceError> {
        public Builder errorCode(String var1);

        public Builder errorCode(FleetErrorCode var1);

        public Builder errorMessage(String var1);

        public Builder errorTimestamp(Instant var1);
    }
}

