/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageState {
    PENDING("PENDING"),
    AVAILABLE("AVAILABLE"),
    FAILED("FAILED"),
    COPYING("COPYING"),
    DELETING("DELETING"),
    CREATING("CREATING"),
    IMPORTING("IMPORTING"),
    VALIDATING("VALIDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageState> VALUE_MAP;
    private final String value;

    private ImageState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageState> knownValues() {
        EnumSet<ImageState> knownValues = EnumSet.allOf(ImageState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageState.class, ImageState::toString);
    }
}

