/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AgentSoftwareVersion;
import software.amazon.awssdk.services.appstream.model.AppCatalogConfigCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ApplicationConfig;
import software.amazon.awssdk.services.appstream.model.RuntimeValidationConfig;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImportedImageRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateImportedImageRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::name)).setter(CreateImportedImageRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SOURCE_AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceAmiId").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::sourceAmiId)).setter(CreateImportedImageRequest.setter(Builder::sourceAmiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAmiId").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::iamRoleArn)).setter(CreateImportedImageRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::description)).setter(CreateImportedImageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::displayName)).setter(CreateImportedImageRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::tags)).setter(CreateImportedImageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RuntimeValidationConfig> RUNTIME_VALIDATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeValidationConfig").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::runtimeValidationConfig)).setter(CreateImportedImageRequest.setter(Builder::runtimeValidationConfig)).constructor(RuntimeValidationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeValidationConfig").build()}).build();
    private static final SdkField<String> AGENT_SOFTWARE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentSoftwareVersion").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::agentSoftwareVersionAsString)).setter(CreateImportedImageRequest.setter(Builder::agentSoftwareVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentSoftwareVersion").build()}).build();
    private static final SdkField<List<ApplicationConfig>> APP_CATALOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppCatalogConfig").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::appCatalogConfig)).setter(CreateImportedImageRequest.setter(Builder::appCatalogConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppCatalogConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateImportedImageRequest.getter(CreateImportedImageRequest::dryRun)).setter(CreateImportedImageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_AMI_ID_FIELD, IAM_ROLE_ARN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, TAGS_FIELD, RUNTIME_VALIDATION_CONFIG_FIELD, AGENT_SOFTWARE_VERSION_FIELD, APP_CATALOG_CONFIG_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateImportedImageRequest.memberNameToFieldInitializer();
    private final String name;
    private final String sourceAmiId;
    private final String iamRoleArn;
    private final String description;
    private final String displayName;
    private final Map<String, String> tags;
    private final RuntimeValidationConfig runtimeValidationConfig;
    private final String agentSoftwareVersion;
    private final List<ApplicationConfig> appCatalogConfig;
    private final Boolean dryRun;

    private CreateImportedImageRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sourceAmiId = builder.sourceAmiId;
        this.iamRoleArn = builder.iamRoleArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.tags = builder.tags;
        this.runtimeValidationConfig = builder.runtimeValidationConfig;
        this.agentSoftwareVersion = builder.agentSoftwareVersion;
        this.appCatalogConfig = builder.appCatalogConfig;
        this.dryRun = builder.dryRun;
    }

    public final String name() {
        return this.name;
    }

    public final String sourceAmiId() {
        return this.sourceAmiId;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final RuntimeValidationConfig runtimeValidationConfig() {
        return this.runtimeValidationConfig;
    }

    public final AgentSoftwareVersion agentSoftwareVersion() {
        return AgentSoftwareVersion.fromValue(this.agentSoftwareVersion);
    }

    public final String agentSoftwareVersionAsString() {
        return this.agentSoftwareVersion;
    }

    public final boolean hasAppCatalogConfig() {
        return this.appCatalogConfig != null && !(this.appCatalogConfig instanceof SdkAutoConstructList);
    }

    public final List<ApplicationConfig> appCatalogConfig() {
        return this.appCatalogConfig;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeValidationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentSoftwareVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppCatalogConfig() ? this.appCatalogConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportedImageRequest)) {
            return false;
        }
        CreateImportedImageRequest other = (CreateImportedImageRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceAmiId(), other.sourceAmiId()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.runtimeValidationConfig(), other.runtimeValidationConfig()) && Objects.equals(this.agentSoftwareVersionAsString(), other.agentSoftwareVersionAsString()) && this.hasAppCatalogConfig() == other.hasAppCatalogConfig() && Objects.equals(this.appCatalogConfig(), other.appCatalogConfig()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImportedImageRequest").add("Name", (Object)this.name()).add("SourceAmiId", (Object)this.sourceAmiId()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("Tags", this.hasTags() ? this.tags() : null).add("RuntimeValidationConfig", (Object)this.runtimeValidationConfig()).add("AgentSoftwareVersion", (Object)this.agentSoftwareVersionAsString()).add("AppCatalogConfig", (Object)(this.appCatalogConfig() == null ? null : "*** Sensitive Data Redacted ***")).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SourceAmiId": {
                return Optional.ofNullable(clazz.cast(this.sourceAmiId()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RuntimeValidationConfig": {
                return Optional.ofNullable(clazz.cast(this.runtimeValidationConfig()));
            }
            case "AgentSoftwareVersion": {
                return Optional.ofNullable(clazz.cast(this.agentSoftwareVersionAsString()));
            }
            case "AppCatalogConfig": {
                return Optional.ofNullable(clazz.cast(this.appCatalogConfig()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("SourceAmiId", SOURCE_AMI_ID_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("RuntimeValidationConfig", RUNTIME_VALIDATION_CONFIG_FIELD);
        map.put("AgentSoftwareVersion", AGENT_SOFTWARE_VERSION_FIELD);
        map.put("AppCatalogConfig", APP_CATALOG_CONFIG_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImportedImageRequest, T> g) {
        return obj -> g.apply((CreateImportedImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String sourceAmiId;
        private String iamRoleArn;
        private String description;
        private String displayName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private RuntimeValidationConfig runtimeValidationConfig;
        private String agentSoftwareVersion;
        private List<ApplicationConfig> appCatalogConfig = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportedImageRequest model) {
            super(model);
            this.name(model.name);
            this.sourceAmiId(model.sourceAmiId);
            this.iamRoleArn(model.iamRoleArn);
            this.description(model.description);
            this.displayName(model.displayName);
            this.tags(model.tags);
            this.runtimeValidationConfig(model.runtimeValidationConfig);
            this.agentSoftwareVersion(model.agentSoftwareVersion);
            this.appCatalogConfig(model.appCatalogConfig);
            this.dryRun(model.dryRun);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceAmiId() {
            return this.sourceAmiId;
        }

        public final void setSourceAmiId(String sourceAmiId) {
            this.sourceAmiId = sourceAmiId;
        }

        @Override
        public final Builder sourceAmiId(String sourceAmiId) {
            this.sourceAmiId = sourceAmiId;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final RuntimeValidationConfig.Builder getRuntimeValidationConfig() {
            return this.runtimeValidationConfig != null ? this.runtimeValidationConfig.toBuilder() : null;
        }

        public final void setRuntimeValidationConfig(RuntimeValidationConfig.BuilderImpl runtimeValidationConfig) {
            this.runtimeValidationConfig = runtimeValidationConfig != null ? runtimeValidationConfig.build() : null;
        }

        @Override
        public final Builder runtimeValidationConfig(RuntimeValidationConfig runtimeValidationConfig) {
            this.runtimeValidationConfig = runtimeValidationConfig;
            return this;
        }

        public final String getAgentSoftwareVersion() {
            return this.agentSoftwareVersion;
        }

        public final void setAgentSoftwareVersion(String agentSoftwareVersion) {
            this.agentSoftwareVersion = agentSoftwareVersion;
        }

        @Override
        public final Builder agentSoftwareVersion(String agentSoftwareVersion) {
            this.agentSoftwareVersion = agentSoftwareVersion;
            return this;
        }

        @Override
        public final Builder agentSoftwareVersion(AgentSoftwareVersion agentSoftwareVersion) {
            this.agentSoftwareVersion(agentSoftwareVersion == null ? null : agentSoftwareVersion.toString());
            return this;
        }

        public final List<ApplicationConfig.Builder> getAppCatalogConfig() {
            List<ApplicationConfig.Builder> result = AppCatalogConfigCopier.copyToBuilder(this.appCatalogConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppCatalogConfig(Collection<ApplicationConfig.BuilderImpl> appCatalogConfig) {
            this.appCatalogConfig = AppCatalogConfigCopier.copyFromBuilder(appCatalogConfig);
        }

        @Override
        public final Builder appCatalogConfig(Collection<ApplicationConfig> appCatalogConfig) {
            this.appCatalogConfig = AppCatalogConfigCopier.copy(appCatalogConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCatalogConfig(ApplicationConfig ... appCatalogConfig) {
            this.appCatalogConfig(Arrays.asList(appCatalogConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCatalogConfig(Consumer<ApplicationConfig.Builder> ... appCatalogConfig) {
            this.appCatalogConfig(Stream.of(appCatalogConfig).map(c -> (ApplicationConfig)((ApplicationConfig.Builder)ApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImportedImageRequest build() {
            return new CreateImportedImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImportedImageRequest> {
        public Builder name(String var1);

        public Builder sourceAmiId(String var1);

        public Builder iamRoleArn(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder runtimeValidationConfig(RuntimeValidationConfig var1);

        default public Builder runtimeValidationConfig(Consumer<RuntimeValidationConfig.Builder> runtimeValidationConfig) {
            return this.runtimeValidationConfig((RuntimeValidationConfig)((RuntimeValidationConfig.Builder)RuntimeValidationConfig.builder().applyMutation(runtimeValidationConfig)).build());
        }

        public Builder agentSoftwareVersion(String var1);

        public Builder agentSoftwareVersion(AgentSoftwareVersion var1);

        public Builder appCatalogConfig(Collection<ApplicationConfig> var1);

        public Builder appCatalogConfig(ApplicationConfig ... var1);

        public Builder appCatalogConfig(Consumer<ApplicationConfig.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

